/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.provider.plp;

import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.Provider;

/**
 * {@link org.unitarou.sgf.Property}CX^X̒g
 * lԂǂ݂₷`ɕԂvoC_[łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public interface PropertyLabelProvider extends Provider {
	
	/**
	 * property̒glԂǂ߂`ɕϊĕԂ܂B
	 * 
	 * @param property
	 * @return
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 */
	String getLabel(GameType gameType, Property property);
	
	/**
	 * ŗp{@link CoordinatesLabelProvider}ݒ肵܂B<br>
	 * ValueTypePOINT, CPOINT, MOVE̎ɗp܂B
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 */
	void setCoordinatesLabelProvider(CoordinatesLabelProvider provider);
	
	/**
	 * ŗpĂ{@link CoordinatesLabelProvider}Ԃ܂B<br>
	 * NXł͌<code>null</code>ԂȂłB
	 * @return
	 */
	CoordinatesLabelProvider getCoordinatesLabelProvider();
}
