/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.swt;

import org.eclipse.swt.graphics.ImageData;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class AlphaBlender {
    
    /**
     * src{@link ImageData#transparentPixel}̃}XNc
     * ߏs܂B
     * ̓Iɂ{@link ImageData#transparentPixel}ɓ̃At@lO
     * ȊÕp[galphaɐݒ肵܂B
     * 
     * @param src
     * @param alpha
     * @return
     */
    static public ImageData createTransparent(ImageData src, int alpha) {
        ImageData ret = new ImageData(src.width, src.height, src.depth, src.palette);
        int[] pixcels = new int[src.width];
        byte[] alphas = new byte[src.width];
        for (int y = 0; y < src.height; ++y) {
            src.getPixels(0, y, pixcels.length, pixcels, 0);
            src.getAlphas(0, y, alphas.length, alphas, 0);
            for (int x = 0; x < alphas.length; ++x) {
                alphas[x] = (byte)((pixcels[x] == src.transparentPixel) ? 0x00 : alpha);
            }
            ret.setPixels(0, y, pixcels.length, pixcels, 0);
            ret.setAlphas(0, y, alphas.length, alphas, 0);
        }
        return ret;
    }

    /**
     * 
     */
    protected AlphaBlender() {
        super();
    }

}
