/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.swt;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.ml.MessageResource;
import org.unitarou.util.ArgumentChecker;

/**
 * enumƂR{{bNX쐬܂B
 * R{{bNX̕{@link java.lang.Enum#toString()}gĂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class EnumCombo<E extends Enum<E>> implements WidgetContainer {
	
	public enum Style {
		/** vf̕ҏW֎~܂B */
		READ_ONLY,
		
		/** I()܂B */
		PERMIT_NO_CHOICE;
	}

    /** uv */
    static private final MessageResource LB_EMPTY 
    		= new MessageResource(EnumCombo.class, "lbEmpty"); //$NON-NLS-1$
	
	private final ListenerList<EnumSelectionListener<E>> list_;

	private final EnumSet<E> items_;
	private Combo combo_;
	private final EnumSet<Style> style_;
	
	/**
	 * R{̃ACeƓEenumێ܂B<br>
	 * {@link Style#PERMIT_NO_CHOICE}̏ꍇ0Ԗڂ̗vfnullێ܂B 
	 */
	private final List<E> enumList_;
	
	/**
	 * ACevfƂďݕsEĨR{{bNX쐬܂B
	 * @param items
	 */
	public EnumCombo(EnumSet<E> items) {
		this(items, EnumSet.of(Style.READ_ONLY, Style.PERMIT_NO_CHOICE));
	}

	/**
	 * @param items
	 * @param readOnly trueɐݒ肷ƑÎ݉\ɂȂ܂B
	 * @throws org.unitarou.lang.NullArgumentException  <code>null</code>̏ꍇB
	 */
	@SuppressWarnings("unchecked") //$NON-NLS-1$
	public EnumCombo(EnumSet<E> items, EnumSet<Style> style) {
		super();
		ArgumentChecker.throwIfNull(items, style);
		list_ = new ListenerList(EnumSelectionListener.class);
		items_ = items.clone();
		combo_ = null;
		style_ = style;
		enumList_ = new ArrayList(items.size() + ((style.contains(Style.PERMIT_NO_CHOICE)) ? 1 : 0));
	}

	
	/**
	 * @return {@link Combo}CX^XԂ܂B
	 * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public Control createContents(Composite parent) {
        combo_ = new Combo(parent, SWT.DROP_DOWN | ((style_.contains(Style.READ_ONLY)) ? SWT.READ_ONLY : 0));
        if (style_.contains(Style.PERMIT_NO_CHOICE)) {
        	combo_.add(LB_EMPTY.get());
        	enumList_.add(null);
        }
        for (E item : items_) {
        	combo_.add(item.toString());
        	enumList_.add(item);
        }
        if (combo_.getItemCount() != 0) {
            combo_.select(0);
        }
        combo_.addSelectionListener(new SelectionListener() {
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {
				fireItemSelected();
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				fireDefaultSelected();
			}
        });
        return combo_;	
    }
	
	private void fireItemSelected() {
		E item = getSelected();
		for (EnumSelectionListener<E> listener : list_.getListeners()) {
			listener.itemSelected(item);
		}
	}
	
	private void fireDefaultSelected() {
		String text = combo_.getText();
		for (EnumSelectionListener<E> listener : list_.getListeners()) {
			listener.defaultSelected(text);
		}
	}
	
	public Combo getCombo() {
		return combo_;
	}
	
	/**
	 * @param item NULLB
	 */
	public void select(E item) {
		if (combo_ == null) {
			return;
		}
		int index = 0;
		for (E e : enumList_) {
			if (e == item) {
				combo_.select(index);
				return;
			}
			++index;
		}
	}
	
	/**
	 * 
	 * @return IEҏWڂ̏ꍇ <code>null</code>Ԃ܂B
	 */
	public E getSelected() {
		int index = combo_.getSelectionIndex();
		if (index == -1) {
			return null;
		}
		return enumList_.get(index);
	}
	
	

	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Combo#getText()
	 */
	public String getText() {
		return combo_.getText();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Combo#setText(java.lang.String)
	 */
	public void setText(String string) {
		combo_.setText(string);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Control#isEnabled()
	 */
	public boolean isEnabled() {
		return combo_.isEnabled();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	public void setEnabled(boolean enabled) {
		combo_.setEnabled(enabled);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#dispose()
	 */
	public void dispose() {
		//Ȃ
	}
	
	public void addListener(EnumSelectionListener<E> listener) {
		list_.add(listener);
	}
	
	public void removeListener(EnumSelectionListener<E> listener) {
		list_.remove(listener);
	}
}
