/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.swt;

import java.util.EnumSet;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import org.unitarou.lang.Strings;
import org.unitarou.util.ArgumentChecker;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class LabeledEnumCombo<E extends Enum<E>> extends EnumCombo<E> {
	
	private String text_;
	private Label label_;
	
	/**
	 * @param items
	 * @param style
	 */
	public LabeledEnumCombo(EnumSet<E> items, EnumSet<Style> style) {
		super(items, style);
		text_ = Strings.EMPTY;
		label_ = null;
	}


	/**
	 * @param items
	 */
	public LabeledEnumCombo(EnumSet<E> items) {
		super(items);
		text_ = Strings.EMPTY;
		label_ = null;
	}

	
	/**
	 * @return Returns the label.
	 */
	@Override
	public String getText() {
		return text_;
	}


	/**
	 * @param text The label to set.
	 */
	@Override
	public void setText(String text) {
		ArgumentChecker.throwIfNull(text);
		text_ = text;
		if (label_ != null) {
			label_.setText(text);
			label_.getParent().layout();
		}
	}


	/* (non-Javadoc)
	 * @see org.unitarou.swt.EnumCombo#createContents(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new RowLayout(SWT.HORIZONTAL));
		label_ = new Label(composite, SWT.RIGHT | SWT.CENTER);
		label_.setText(text_);
		super.createContents(composite);
		return composite;
	}
}
