/* FormLayouts.java
 * 
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.swt;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;

/**
 * {@link org.eclipse.swt.layout.FormLayout}֘Ã[eBeBNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class Layouts {
    
    static public FormLayout createForm(int marginHeight, int marginWidth, int spacing) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 2;
        formLayout.marginWidth = 2;
        formLayout.spacing = 2;
        return formLayout;
    }
    
    static public RowLayout createRow(int type, int margin, int spacing) {
        RowLayout rowLayout = new RowLayout(type);
        rowLayout.marginBottom = margin;
        rowLayout.marginHeight = margin;
        rowLayout.marginLeft = margin;
        rowLayout.marginTop = margin;
        rowLayout.spacing = spacing;
        return rowLayout;
    }
    
    static public FormData createSpreadFormData(int margine) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, margine);
        formData.top = new FormAttachment(0, margine);
        formData.right = new FormAttachment(100, -margine);
        formData.bottom = new FormAttachment(100,-margine);
        return formData;
    }

    /**
     * 
     */
    protected Layouts() {
        super();
    }
}
