/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.swt;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;

import org.unitarou.util.ArgumentChecker;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class Line {

	/**
	 * ̎n_BKs_.x < e_.x
	 */
	private final Point s_;
	
	/**
	 * ̏I_
	 */
	private final Point e_;
	
	
	
	/**
	 * @param s ̎n_
	 * @param e ̏I_
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
	 */
	public Line(Point s, Point e) {
		super();
		ArgumentChecker.throwIfNull(s, e);
		if (s.equals(e)) {
			throw new IllegalArgumentException();
		}
		if (s.x < e.x) {
			s_ = new Point(s.x, s.y);
			e_ = new Point(e.x, e.y);
		} else {
			s_ = new Point(e.x, e.y);
			e_ = new Point(s.x, s.y);
		}
	}

	
	/**
	 * tƂ̐Ƃ̋vZĕԂ܂B
	 * 
	 * @param t ΏۂƂȂ|Cg
	 * @return
	 */
	public double distance(Point t) {
		ArgumentChecker.throwIfNull(t);
		
		if ((e_.x == s_.x)  && (Math.min(s_.y, e_.y) < t.y) && (t.y < Math.max(s_.y, e_.y))){
			return Math.abs(s_.x - t.x);
			
		} else if ((e_.y == s_.y) && (s_.x < t.x) && (t.x < e_.x)) {
			return Math.abs(s_.y - t.y); 
		}

		//ȈՃ`FbN
		if (t.x < s_.x) {
			return Math.sqrt(Geometry.distanceSquared(t,s_));
		} else if (e_.x < t.x) {
			return Math.sqrt(Geometry.distanceSquared(t,e_));
		}
		

		final double  a = e_.x - s_.x,
						b = e_.y - s_.y;

		final double  a2 = a * a,
						b2 = b * b;

//		return Math.abs((b2 * (s_.x - t.x) - a * b * (s_.y - t.y)) / (a * Math.sqrt(a2 + b2)));
		return Math.abs(Math.sqrt(b2 + a2) / (b2 + a2) * (b * (s_.x - t.x) - a * (s_.y - t.y)));
	}
}
