/* Rectangles.java
 * 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.swt;

import org.eclipse.swt.graphics.Rectangle;

/**
 * {@link org.eclipse.swt.graphics.Rectangle}p̃[eBeBNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class Rectangles {
    
    /** outerƒS킹ratio{`쐬ĕԂ܂B*/
    static public Rectangle createScaled(Rectangle outer, double ratio) {
        return createScaled(outer, ratio, 0);
    }
    
    /**
     * outerƒS킹ratio{`쐬ĕԂ܂B
     * A`̒(ZӒӖ킸)minȉɂȂꍇ́A
     * minɐ؂グ܂B
     */
    static public Rectangle createScaled(Rectangle outer, double ratio, int min) {
        return createScaled(outer, ratio, 0, outer.width);
    }

    /**
     * outerƒS킹ratio{`쐬ĕԂ܂B
     * A`̒(ZӒӖ킸)minȉɂȂꍇminɐ؂グA
     * `̒(ZӒӖ킸)maxȏɂȂꍇmaxɐ؂̂Ă܂B
     */
    static public Rectangle createScaled(Rectangle outer, double ratio, int min, int max) {
        int sizeW = resize(outer.width, ratio, min, max);
        int paddingW = (outer.width - sizeW) / 2;
        int sizeH = resize(outer.height, ratio, min, max);
        int paddingH = (outer.height - sizeH) / 2;
        return new Rectangle(outer.x + paddingW, outer.y + paddingH, sizeW, sizeH);
    }
    
    /**
     * sizeratio{minmax͈͓̔Ɏ߂ĕԂ܂B 
     */
    static public int resize(int size, double ratio, int min, int max) {
        int ret = (int)Math.round(size * ratio);
        ret = Math.max(min, ret);
        ret = Math.min(max, ret);
        return ret;
    }
    
    /**
     * 
     */
    protected Rectangles() {
        super();
    }

}
