/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.swt;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;

import org.unitarou.lang.Strings;
import org.unitarou.util.ArgumentChecker;

/**
 * SWTCu[p̃[eBeBłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class Swts {
	
	/**
	 * resourcenull܂{@link Resource#dispose()}ĂȂꍇɁA
	 * {@link Resource#dispose()}Ăяo܂B
	 * 
	 * @param resource
	 */
	static public void disposeQuietly(Resource resource) {
        if ((resource != null) && !resource.isDisposed()) {
        	resource.dispose();
        }
	}
	
	/**
	 * Rectangle̍̍WԂ܂B
	 * @param rectangle
	 * @return
	 */
	static public Point topLeft(Rectangle rectangle) {
		ArgumentChecker.throwIfNull(rectangle);
		return Geometry.getLocation(rectangle);
	}
 
	/**
	 * RectanglẻE̍WԂ܂B
	 * @param rectangle
	 * @return
	 */
	static public Point bottomRight(Rectangle rectangle) {
		ArgumentChecker.throwIfNull(rectangle);
		return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
	}

	/**
	 * SWTTextpɕϊ郆[eBeBłB<br>
	 * ȉ̕ϊsĂ܂<br>
	 * ESWTWidgetText͕񒆂ɐR[h(0)Ƃȍ~
	 * @\Ȃ̂Ŏ菜ĕԂĂ܂B
	 * ESWTWidgetłLINE_SEPARATOR̓VXẻsR[hɕϊĂKv܂B
	 * @param charSequence
	 * @return
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 */
	static public String toWidgetText(String charSequence) {
		ArgumentChecker.throwIfNull(charSequence);
		StringBuilder builder = new StringBuilder(charSequence.length());
		CharacterIterator ip = new StringCharacterIterator(charSequence);
		for (char c = ip.first(); c != CharacterIterator.DONE; c = ip.next()) {
			if (Character.isISOControl(c) && !Character.isWhitespace(c)) {
				continue;
	    	}
			if (c == '\r') {
				if (ip.next() != '\n') {
					ip.previous();
				}
				builder.append(Strings.LINE_SEPARATOR);
			} else if (c == '\n') {
				builder.append(Strings.LINE_SEPARATOR);
			} else {
				builder.append(c);
			}
		}
		return builder.toString();
	}
	
    /**
     * p1p2̘aԂ܂B
     * typeŎw肳ꂽ݂̂ɘaƂA
     * w肳ȂɂĂ͕܂Ԃ܂B
     * typéA{@link SWT#HORIZONTAL}A{@link SWT#VERTICAL}łB
     */
    static public Point add(Point p1, Point p2, int type) {
    	Point ret = new Point(0, 0);
        if ((type & SWT.HORIZONTAL) != 0) {
            ret.x = p1.x + p2.x;
        } else {
            ret.x = Math.max(p1.x, p2.x);
        }
        
        if ((type & SWT.VERTICAL) != 0) {
            ret.y = p1.y + p2.y;
        } else {
            ret.y = Math.max(p1.y, p2.y);
        }
        return ret;
    }
    
	/**
     * 
     */
    protected Swts() {
        super();
    }
}
