/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation, unitarou <boss@unitarou.org> and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     unitarou - customize VCL like(set minimum size, some part fix at resize, 
 *                decorate splitter, etc...)
 *******************************************************************************/
package org.unitarou.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

/**
 * This class provides the layout for SashForm
 * 
 * @see SashForm
 */
class USashFormLayout extends Layout {
	@Override
	protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
		USashForm sashForm = (USashForm)composite;
		Control[] cArray = sashForm.getControls(true);
		int width = 0;
		int height = 0;
		if (cArray.length == 0) {
			if (wHint != SWT.DEFAULT)
				width = wHint;
			if (hHint != SWT.DEFAULT)
				height = hHint;
			return new Point(width, height);
		}
		// determine control sizes
		boolean vertical = sashForm.getOrientation() == SWT.VERTICAL;
		int maxIndex = 0;
		int maxValue = 0;
		for (int i = 0; i < cArray.length; i++) {
			if (vertical) {
				Point size = cArray[i].computeSize(wHint, SWT.DEFAULT, flushCache);
				if (size.y > maxValue) {
					maxIndex = i;
					maxValue = size.y;
				}
				width = Math.max(width, size.x);
			} else {
				Point size = cArray[i].computeSize(SWT.DEFAULT, hHint, flushCache);
				if (size.x > maxValue) {
					maxIndex = i;
					maxValue = size.x;
				}
				height = Math.max(height, size.y);
			}
		}
		// get the ratios
		long[] ratios = new long[cArray.length];
		long total = 0;
		for (int i = 0; i < cArray.length; i++) {
			Object data = cArray[i].getLayoutData();
			if (data != null && data instanceof USashFormData) {
				ratios[i] = ((USashFormData)data).weight;
			} else {
				data = new USashFormData();
				cArray[i].setLayoutData(data);
				((USashFormData)data).weight = ratios[i] = ((200 << 16) + 999) / 1000;
			}
			total += ratios[i];
		}
		int sashwidth = sashForm.getWholeSashWidth();
		if (vertical) {
			if (ratios[maxIndex] == 0) {
				height += maxValue * cArray.length;
			} else {
				height += (int)(total * maxValue / ratios[maxIndex]);
			}
			height += (cArray.length - 1) * sashwidth;
		} else {
			if (ratios[maxIndex] == 0) {
				width += maxValue * cArray.length;
			} else {
				width += (int)(total * maxValue / ratios[maxIndex]);
			}
			width += (cArray.length - 1) * sashwidth;
		}
		width += sashForm.getBorderWidth() * 2;
		height += sashForm.getBorderWidth() * 2;
		if (wHint != SWT.DEFAULT)
			width = wHint;
		if (hHint != SWT.DEFAULT)
			height = hHint;
		return new Point(width, height);
	}

	@Override
	protected boolean flushCache(Control control) {
		return true;
	}

	@Override
	protected void layout(Composite composite, boolean flushCache) {
		USashForm sashForm = (USashForm)composite;
		if (!sashForm.updateSashAndControl()) {
			return;
		}

		Control[] controls = sashForm.getControls();
		// get the ratios
		long[] ratios = new long[controls.length];
		long total = 0;
		int fixedSize = 0; //TCYŕύXȂ
		for (int i = 0; i < controls.length; i++) {
			Object data = controls[i].getLayoutData();
			if (data == null || !(data instanceof USashFormData)) {
				data = new USashFormData();
				controls[i].setLayoutData(data);
				((USashFormData)data).weight = ((200 << 16) + 999) / 1000;
			}
			
			ratios[i] = ((USashFormData)data).weight;
			fixedSize += ((USashFormData)data).getActualSize();
			total += ratios[i];
		}

		Sash[] sashes = sashForm.getSashes();
		Rectangle area = sashForm.getClientArea();
		int sashwidth = sashForm.getWholeSashWidth();
		if (sashForm.getOrientation() == SWT.HORIZONTAL) {
			final int allocatableWidth = area.width - sashes.length * sashwidth - fixedSize;
			USashFormData formData = (USashFormData)controls[0].getLayoutData();
			int width = calcSize(formData, allocatableWidth, total);
			int x = area.x;
			controls[0].setBounds(x, area.y, width, area.height);
			x += width;
			for (int i = 1; i < controls.length - 1; i++) {
				sashes[i - 1].setBounds(x, area.y, sashwidth, area.height);
				x += sashwidth;
				formData = (USashFormData)controls[i].getLayoutData();
				width = calcSize(formData, allocatableWidth, total);
				controls[i].setBounds(x, area.y, width, area.height);
				x += width;
			}
			if (controls.length > 1) {
				sashes[sashes.length - 1].setBounds(x, area.y, sashwidth, area.height);
				x += sashwidth;
				width = area.width - x;
				controls[controls.length - 1].setBounds(x, area.y, width, area.height);
			}
		} else {
			final int allocatableHeight = area.height - sashes.length * sashwidth - fixedSize;
			USashFormData formData = (USashFormData)controls[0].getLayoutData();
			int height = calcSize(formData, allocatableHeight, total);
			int y = area.y;
			controls[0].setBounds(area.x, y, area.width, height);
			y += height;
			for (int i = 1; i < controls.length - 1; i++) {
				sashes[i - 1].setBounds(area.x, y, area.width, sashwidth);
				y += sashwidth;
				formData = (USashFormData)controls[i].getLayoutData();
				height = calcSize(formData, allocatableHeight, total);
				controls[i].setBounds(area.x, y, area.width, height);
				y += height;
			}
			if (controls.length > 1) {
				sashes[sashes.length - 1].setBounds(area.x, y, area.width, sashwidth);
				y += sashwidth;
				height = area.height - y;
				controls[controls.length - 1].setBounds(area.x, y, area.width, height);
			}

		}
	}

	/**
	 * {@link USashFormData#getActualSize()}̒lɉđÓȃTCYvZ郍WbNłB<br>
	 * {@link USashFormData#getActualSize()}0傫ꍇ͂̒lA
	 * ȊȌꍇ(int)(formData.weight * allocatableSize / total)Ԃ܂B
	 * 
	 * @param formData
	 * @param allocatableWidth USashForm̃NCAgGASashl(ϑ)
	 * @param total USashFormɓo^ĂRg[weight̘a
	 * @return
	 */
	private int calcSize(USashFormData formData, int allocatableSize, long total) {
		if (0 < formData.getActualSize()) {
			return formData.getActualSize();
		}
		return (int)(formData.weight * allocatableSize / total);
	}
}
