/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.util;

import java.util.ArrayList;

import org.unitarou.lang.NullArgumentException;

/**
 * {@link org.unitarou.util.Adaptable}p̃[eBeBNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class Adaptables {
    
    /**
     * adaptables̊eCX^Xadapter̂́ATuNXANX
     * ꂩ̃CX^XĂƂɁÃCX^XQԂ܂B<br>
     * ʂƂėLadapter̔z񂪕Ԃ܂B
     * ȂAadaptables̒nullvf͖܂B
     * 
     * @throws NullArgumentException null̏ꍇB
     */
    static public Object[] getAdapters(Class adapter, Adaptable[] adaptables) {
        ArgumentChecker.throwIfNull(adapter, adaptables);
        ArrayList<Object> ret = new ArrayList<Object>(adaptables.length);
        for (int i = 0; i < adaptables.length; ++i) {
            if (adaptables[i] == null) {
                continue;
            }
            Object obj = adaptables[i].getAdapter(adapter);
            if (obj != null) {
                ret.add(obj);
            }
        }
        return ret.toArray();
    }

    /**
     * 
     */
    protected Adaptables() {
        super();
    }
}
