/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.util;

import java.util.Collection;

import org.unitarou.lang.NullArgumentException;


/**
 * \bḧ`FbNāA
 * ᔽ{@link java.lang.IllegalArgumentException}n
 * O𑗏o`FbJ[łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class ArgumentChecker {

    /**
     * arg1null̎{@link NullArgumentException}𑗏o܂B
     * @throws NullArgumentException 
     */
    static public void throwIfNull(Object arg1) {
        if (arg1 == null) {
            throw new NullArgumentException(arg1);
        }
    }

    /**
     * arg1arg2null̎{@link NullArgumentException}𑗏o܂B
     * @throws NullArgumentException 
     */
    static public void throwIfNull(Object arg1, Object arg2) {
        if ((arg1 == null) || (arg2 == null)){
            throw new NullArgumentException(arg1, arg2);
        }
    }

    /**
     * arg1, arg2, arg3̂ǂꂩnull̎{@link NullArgumentException}𑗏o܂B
     * @throws NullArgumentException 
     */
    static public void throwIfNull(Object arg1, Object arg2, Object arg3) {
        if ((arg1 == null) || (arg2 == null) || (arg3 == null)){
            throw new NullArgumentException(arg1, arg2, arg3);
        }
    }

    /**
     * arg1, arg2, arg3, arg4̂ǂꂩnull̎{@link NullArgumentException}𑗏o܂B
     * @throws NullArgumentException 
     */
    static public void throwIfNull(Object arg1, Object arg2, Object arg3, Object arg4) {
        if ((arg1 == null) || (arg2 == null) || (arg3 == null) || (arg4 == null)){
            throw new NullArgumentException(arg1, arg2, arg3, arg4);
        }
    }

    /**
     * argŝǂ炩Płnull̎{@link NullArgumentException}𑗏o܂B
     * @throws NullArgumentException 
     */
    static public void throwIfNull(Object... args) {
        if (args == null) {
            throw new NullArgumentException("Argument array must not be null."); //$NON-NLS-1$
        }

    	for (Object obj : args) {
    		if (obj == null) {
                throw new NullArgumentException(args);
    		}
    	}
    }

    /**
     * number(0)̏ꍇ{@link IllegalArgumentException}𑗏o܂B
     * @param number `FbN鐔l
     * @throws IllegalArgumentException numbeȑꍇB
     */
    static public void throwIfNegative(int number) {
        if (number < 0) {
		    throw new IllegalArgumentException(
		            "Argument must not be minus value. Parameter is "  //$NON-NLS-1$
		            + number);
        }
    } 
    
    /**
     * indexcollection{@link Collection#size()}͈̔͊ȌꍇɁA
     * IllegalArgumentException𑗏o܂B
     * @param index
     * @param collection
     */
    static public void throwsIfOutOfBounds(int index, Collection<?> collection) {
    	ArgumentChecker.throwIfNull(new Integer(index), collection);
    	if ((index < 0) || (collection.size() <= index)) {
    		throw new IllegalArgumentException();
    	}
    }
    /**
     * 
     */
    protected ArgumentChecker() {
        super();
    }

}
