/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.util;

/**
 * uqvtB^[̒ۃNXłB
 * TuNXł{@link #filter(T)}̐擪Ŏ̂悤ɐe\bhĂяoĂF
 * <pre>
 * T filtered = super.filter(obj);
 * cTuNXł̃tB^[
 * </pre>
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
abstract public class NestedFilter<T> implements Filter<T> {

	protected final Filter<T> parent_;
	
	/**
	 * {@link #NestedFilter(Filter)}̈<code>null</code>
	 * ꂽꍇƓłB 
	 */
	public NestedFilter() {
		this(null);
	}
	
	/**
	 * @param parent null܂B
	 */
	public NestedFilter(Filter<T> parent) {
		super();
		parent_ = parent;
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.util.Filter#filter(T)
	 */
	public T filter(T obj) throws FilterException {
        ArgumentChecker.throwIfNull(obj);
        // eƂ͐eĂяoB
        return (parent_ != null) ? parent_.filter(obj) : obj; 
	}

}
