/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.util;

import java.text.NumberFormat;

/**
 * fobNȂǎԌvړIƂXgbvEHb`łB
 * ŏPʂ̓imbłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class StopWatch {
	
	
	private long start_;
	
	private long lap_;
	
	private long stop_;
	
	private final NumberFormat format_;

	/**
	 * XgbvEHb`X^[gԂō쐬܂B 
	 */
	public StopWatch() {
		this(true);
	}
	
	/**
	 * ̃NX̃vCRXgN^łB
	 * withStartŃXgbvEHb`̏ԁiJn/~jł܂B
	 * @param <code>true</code>ɐݒ肷 쐬ƓɃX^[gĂB
	 */
	public StopWatch(boolean withStart) {
		super();
		start_ = 0;
		lap_ = 0;
		stop_ = 0;
		format_ = NumberFormat.getNumberInstance();
		format_.setMinimumFractionDigits(6);
		if (withStart) {
			start();
		}
	}

	
	/**
	 * XgbvEHb`Jn܂B
	 * 
	 * @return ȑO{@link #start()}Ă炱܂ł̌oߎ[imb]
	 */
	public long start() {
		long time;
		stop_ =  System.nanoTime();
		time = stop_ - start_;
		start_ = stop_;
		lap_ = start_;
		return time;
	}
	
	/**
	 * Jn𓮂ɁAOstart()܂lap()Ă̌oߎԂ܂B
	 * @return
	 */
	public long lap() {
		long nextLap = System.nanoTime();
		long ret = nextLap - lap_;
		lap_ = nextLap;
		return ret;
	}
	
	/**
	 * Jn𓮂ɁAOstart()܂lap()Ă̌oߎbPʂŕ\܂B
	 * @return
	 */
	public String lapSecond() {
		return format_.format(lap() / (1000.0 * 1000.0 * 1000.0));
	}

	/**
	 * XgbvEHb`~܂B
	 * @return ȑO{@link #start()}Ă炱܂ł̌oߎ[imb]
	 */
	public long stop() {
		long time;
		stop_ =  System.nanoTime();
		time = stop_ - start_;
		start_ = stop_;
		return time;
	}
	
	/**
	 * XgbvEHb`~āAoߎԂbPʂŕ\܂B
	 * @return
	 */
	public String stopSecond() {
		return format_.format(stop() / (1000.0 * 1000.0 * 1000.0));
	}
}
