/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * GOFStrategyƌĂ΂悤ȈÃNXꌳIɓo^Ǘ郌WXgłB<br>
 * <b>݁A}`Xbhɂ͑ΉĂ܂B܂Abstract strategyɂɓo^ȂConcrete strategyo^܂B</b><br>
 * ܂߂Abstract strategyƂȂNX{@link #registerStrategy(Class)}œo^܂B
 * Concrete strategyNX{@link #registerConcreteStrategy(Class)}œo^܂B
 * o^Concrete strategyNX́A{@link #getConcreteStrategies(Class)}
 * {@link #getConcreteStrategyInstances(Class)}pČĂяo܂B
 * O҂̃\bhConcrete strategyNX̐ɃRXgxꍇɗp܂B
 * ҂̃\bh͕KCX^X𐶐ĕԂ܂B
 * ĐRXgӎAftHgRXgN^ꍇ̊ȈՃ\bhłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public final class StrategyRegistrar {
    /**
     * ^[{@link Class}A{@link java.util.List}[{@link Class}]]łB
     * key͒ۓIStrategỹNXAValueConcreteStrategỹXgłB 
     */
    private final Map<Class<?>, List<Class<?>>> registerMap_;
    
    /**
     * g̃WXg쐬܂B
     */
    public StrategyRegistrar() {
        super();
        registerMap_ = new HashMap<Class<?>, List<Class<?>>>();
    }

    /**
     * ۓIStrategyo^܂B
     * abstractStragety{@link #getConcreteStrategies(Class)}A
     * {@link #getConcreteStrategyInstances(Class)}̈ƂȂ܂B
     * 
     * @param abstractStragety 
     * @return abstractStragetyVKɓo^ꂽꍇtrueBɓo^Ăꍇfalse
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public boolean registerStrategy(Class<?> abstractStragety) {
        ArgumentChecker.throwIfNull(abstractStragety);
        List<Class<?>> list = registerMap_.get(abstractStragety);
        if (list == null) {
            list = new ArrayList<Class<?>>();
            registerMap_.put(abstractStragety, list);
            return true;
        }
        return false;
    }
    
    /**
     * Concrete strategyo^܂B
     * Abstract strategyƂ̑Ή͎Iɍs܂B
     * Ȃ킿AŌsA\Abstract strategySĂɓo^܂B
     * 
     * @param concreteStrategy
     * @return Conclete strategyo^ꂽAbstract strategy̔zB
     *          1o^łȂꍇ͗vfO̔zԂAnull͕ԂȂB
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    public Class<?>[] registerConcreteStrategy(Class<?> concreteStrategy) {
        ArgumentChecker.throwIfNull(concreteStrategy);
        
        List<Class> registered = new ArrayList<Class>();
        for (Map.Entry<Class<?>, List<Class<?>>> entry : registerMap_.entrySet()) {
            Class<?> abstractStrategy = entry.getKey();
            if (abstractStrategy.isAssignableFrom(concreteStrategy)) {
                List<Class<?>> list = entry.getValue();
                list.add(concreteStrategy);
                registered.add(abstractStrategy);
            }
        }
        return registered.toArray(new Class<?>[registered.size()]);
    }
    
    /**
     * ݂܂łɓo^ĂSWXg܂B
     */
    public void clear() {
        registerMap_.clear();
    }
    
    /**
     * {@link #registerStrategy(Class)}œo^ꂽSStrategyԂ܂B
     * @return
     */
    public Class<?>[] getStrategies() {
        return registerMap_.keySet().toArray(new Class<?>[registerMap_.size()]);
    }

    /**
     * ݓo^ĂConcrete strategy̒ŁA
     * Abstract strategyɑΉSStrategỹNXzԂ܂B
     * 
     * @param abstractStrategy
     * @return Abstract strategyɓo^ĂConcrete strategy̔zB
     *          1o^ĂȂꍇ͗vfO̔zԂAnull͕ԂȂB
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    @SuppressWarnings("unchecked") //$NON-NLS-1$
	public <T> Class<T>[] getConcreteStrategies(Class<T> abstractStrategy) {
        ArgumentChecker.throwIfNull(abstractStrategy);
        
        Class<T>[] ret = (Class<T>[])Array.newInstance(abstractStrategy.getClass(), 0);
        List<Class<?>> list =registerMap_.get(abstractStrategy);
        if (list == null) {
            return ret;
        }
        
        List<Class<T>> classes = new ArrayList<Class<T>>(list.size());
        for (Class<?> clazz : list) {
        	classes.add((Class<T>)clazz);
        }
        return classes.toArray(ret);
    }
    
    /**
     * ݓo^ĂConcrete strategy̒ŁA
     * Abstract strategyɑΉSStrategyNX̃CX^XzԂ܂B
     * ԂCX^X́Ã\bhĂяo邽тɐVKɍ쐬܂B
     * ܂CX^X̍쐬ɂConcrete strategẙeftHgRXgN^
     * tNVgČĂяoĂ܂B
     * ftHgRXgN^ȂConcrete strategyɂĂ͖A
     * ʂ̔zɂ͓܂B
     * 
     * @param abstractStrategy
     * @return Abstract strategyɓo^ĂConcrete strategy̔zB
     *          1CX^XłȂꍇ͗vfO̔zԂAnull͕ԂȂB
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    @SuppressWarnings("unchecked") //$NON-NLS-1$
	public <T> T[] getConcreteStrategyInstances(Class<T> abstractStrategy) {
        ArgumentChecker.throwIfNull(abstractStrategy);
        
        T[] ret = (T[])Array.newInstance(abstractStrategy, 0);
        List<Class<?>> list =registerMap_.get(abstractStrategy);
        if (list == null) {
        	return ret;
        }
        
        List<T> instances = new ArrayList<T>(list.size());
        for (Class<?> clazz : list) {
        	
            try {
            	instances.add((T)clazz.newInstance());

            } catch (InstantiationException ignore) {
                // CX^Xs͖܂B
            } catch (IllegalAccessException ignore) {
                // CX^Xs͖܂B
            }
        	
        }
        return instances.toArray(ret);
    }
}
