/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;


/**
 * QƂŒlێListłB
 * static\bhp̃Xi[ȂǁA폜̃^C~OƂÂ炢
 * CX^X̊i[ɌĂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class WeakedList<T> implements Iterable<T> {
	private final ReferenceQueue<T> referenceQueue_;
	/**
	 * WeakedReferencei[܂B
	 * ^[Reference]łB
	 */
	private final LinkedList<Reference<T>> linkedList_;

	/**
	 * 
	 */
	public WeakedList() {
		super();
		referenceQueue_ = new ReferenceQueue<T>();
		linkedList_ = new LinkedList<Reference<T>>();
	}

	/**
	 * oXgɒǉ܂B<br>
	 * ǉɂRXg͖Yp萔ԂłB
	 * 
	 * @return f[^ǉAXgωꍇtrue
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
	 */
	public boolean add(T o) {
	    ArgumentChecker.throwIfNull(o);
		return linkedList_.add(new WeakReference<T>(o, referenceQueue_));
	}

	/**
	 * osSăXgɒǉ܂B<br>
	 * ǉɂRXg͖Yp萔ԂłB
	 * @param os
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
	 */
	public void addAll(WeakedList<T> os) {
	    ArgumentChecker.throwIfNull(os);
	    for (T o : os) {
	    	linkedList_.add(new WeakReference<T>(o, referenceQueue_));
	    }
	}

	/**
	 * oXgɑ݂ꍇɍ폜trueԂ܂B<br>
	 * ܂Agcɂč폜ꂽCX^X̎QƂNA[܂B
	 * 폜ɂRXg̓Xg̃TCYɑ΂Đ`ԂłB
	 * 
	 * @param o 폜Ώۂ̃CX^XBnull̏ꍇ͉ȂB
	 * @return 폜ɐtrueB
	 */
	public boolean remove(T o) {
		boolean finds = false;
		Iterator<Reference<T>> ip = linkedList_.iterator();
		while (ip.hasNext()) {
			T obj = ip.next().get();
			if (obj == null) {
				ip.remove();
				continue;
			} else if (obj.equals(o)){
				ip.remove();
				finds = true;
			}
		}
		return finds;
	}

	/**
	 * gcɂăNA[ĂȂSCX^XԂ܂B<br>
	 * ܂Agcɂč폜ꂽCX^X̎QƂNA[܂B
	 * ǉɂRXg̓Xg̃TCYɑ΂Đ`ԂłB
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
	 */
	public T[] toArray(T[] holder) {
	    ArgumentChecker.throwIfNull((Object)holder);
	    List<T> liveInstances = getLiveInstances();
		return liveInstances.toArray(holder);
	}
	
	/**
	 * ݐĂ(GCĂȂ)CX^X̃XgԂ܂B
	 * @return
	 */
	private List<T> getLiveInstances() {
		List<T> instances = new ArrayList<T>(linkedList_.size());
		Iterator<Reference<T>> ip = linkedList_.iterator();
		while (ip.hasNext()) {
		    T obj = ip.next().get();
			if (obj == null) {
				ip.remove();
 			} else {
 				instances.add(obj);
 			}
		}
		return instances;
	}
	

	/**
	 * Ce[^Ԃ܂B
	 * ̃Ce[^{@link Iterator#remove()}͕K
	 * UnsupportedOperationException𑗏o܂B
	 * 
	 * @see java.lang.Iterable#iterator()
	 */
	public Iterator<T> iterator() {
		return new IteratorImpl();
	}
	
	/**
	 * Xg̃Ce[^łB
	 */
	private class IteratorImpl implements Iterator<T> {

		private final List<T> array_;
		private int index_;
		private IteratorImpl() {
			array_ = getLiveInstances();
			index_ = 0;
		}
		
		/* (non-Javadoc)
		 * @see java.util.Iterator#hasNext()
		 */
		public boolean hasNext() {
			return (index_ < array_.size());
		}

		/* (non-Javadoc)
		 * @see java.util.Iterator#next()
		 */
		public T next() {
			if (hasNext()) {
				return array_.get(index_++);
			} 
			throw new NoSuchElementException();
		}

		/* (non-Javadoc)
		 * @see java.util.Iterator#remove()
		 */
		public void remove() {
			throw new UnsupportedOperationException();
		}
	}
}
