/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita;

import java.io.File;

import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.view.WindowController;


/**
 * AvP[Vsŏʂ̃C^[tFCXłB
 * AvP[VGg[ƃC^[tFCX𕪂邱ƂŁA
 * JFaceAswingƂEBhECu[؂ւ邱Ƃ
 * ړIƂĂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public interface Application {
	/**
	 * [UɃbZ[WʒmƂ̌^\܂B
	 */
	public enum MessageLevel{
		/** G[\bZ[W^CvłB */ 
		ERROR,
		
		/** x\bZ[W^CvłB */ 
		WARNING,
		
		/** \bZ[W^CvłB */ 
		INFORMATION,
	}
	

	/**
	 * AvP[VJn܂B
	 * ̃\bh͏I܂Ŗ߂Ă܂B 
	 * ܂̃\bh͂ȂOoׂł͂܂B
	 * ̃\bhŗOK؂ɏ(OoE_CAO\)
	 * sĂB
	 * @param files R}hCw肳ꂽt@C̔złB
	 *               ̃\bhɓniKŁA݂Óȃt@C̔zƂ݂ȂOKłB
	 *               R}hCŎw肪ꍇ́Avf0̔zԂ܂B
	 */
    void start(File[] files);

    /**
     * GCŊJȂ\[XJ܂B
     * NCAg{@link #start()}Ɏs邱Ƃۏ؂ȂĂ͂Ȃ܂B 
     */
    void dispose();

    /**
	 * VWindow𐶐܂B
     */
    void createWindow();

    /**
	 * ݊JĂSĂWindowj܂B
     */
    void closeAllWindows();
    
    /**
     * AvP[ṼReLXgԂ܂B
     */
    Context getContext();
    
	
	/**
	 * 񃌃xw肵āAOK{^\郁bZ[W_CAO\܂B
	 * @param type
	 * @param title
	 * @param message
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 */
	void openMessageDialog(MessageLevel level, String title, String message);
	
	
	/**
	 * fBNgI_CAOAvP[V[_ŕ\܂B<br>
	 * [UfBNgIꍇ͂̃fBNgԂ܂B
	 * LZꍇ<code>null</code>Ԃ܂B
	 * @param title _CAÕ^Cgo[ɕ\镶łB
	 * @param message _CAOŃ[Uɕ\郁bZ[WłB
	 * @param currentDirectory \_ł̃fBNgłB
	 * @return
	 * @throws org.unitarou.lang.NullArgumentException  <code>null</code>̏ꍇB
	 */
	File openDirectoryDialog(String title, String message, File currentDirectory);

	
	/**
	 * ݃AvP[VێĂSWindow̃Rg[Ԃ܂B<br>
	 * KPȏŗvf<code>null</code>ł͂ȂzԂĂB
	 * @return
	 */
	WindowController[] getAllController();
}