/*  
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.swing.JOptionPane;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.lang.Logging;
import org.unitarou.lang.Runtimes;
import org.unitarou.lang.Strings;
import org.unitarou.lang.Logging.Level;
import org.unitarou.ml.MessageResource;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.io.dl.DefaultHttpDownloader;
import org.unitarou.sgf.io.dl.HttpDownloader;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.yukinoshita.Application.MessageLevel;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.NoVariationProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;


/**
 * AvP[V̎sJnGg[NXłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class Yukinoshita {	
	/**
     * AvP[VŜ̐ݒsvpeBt@C̃t@CłB
     * Wł́gyukinoshita.propertieshƂt@CɂȂ܂B
     */
    static private final String PROPERTIES_FILE_NAME = "." + File.separator + "yukinoshita.properties"; //$NON-NLS-1$ //$NON-NLS-2$

    /** ̃NX̃K[łB*/
    static private final Log log_s_;

    
    /**
     * ut@C̓ǂݍ݂Ɏs܂v
     */
    static private final MessageResource NT_FILE_READ_ERROR;
    
    /**
	 * LmV^̐ݒt@C{0}ǂݍ߂܂łB
	 * KvȍڂɂĂ͑SăftHglg܂B
	 */
    static private final MessageResource MSG_PROPERTIES_FILE_NOT_FOUND;
    
    
    /**
     * AvP[VŜňԍŏɌĂяo鏉\bhłB
     */
    static  {
//    	System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Log4JLogger"); //$NON-NLS-1$ //$NON-NLS-2$
    	
	    log_s_ = LogFactory.getLog(Yukinoshita.class);
	    NT_FILE_READ_ERROR = new MessageResource(Yukinoshita.class,"ntFileReadError"); //$NON-NLS-1$
	    MSG_PROPERTIES_FILE_NOT_FOUND = new MessageResource(Yukinoshita.class, "msgPropertiesFileNotFound"); //$NON-NLS-1$
	}
	
    /**
	 * I/OG[ɂALmV^ݒt@C"{0}"̓ǂݍ݂Ɏs܂B
	 * KvȍڂɂĂ͑SăftHglg܂B
	 */
    static private final MessageResource MSG_PROPERTIES_READ_ERROR
    		= new MessageResource(Yukinoshita.class, "msgPropertiesReadError"); //$NON-NLS-1$
    
    
    /**
     * uݒt@CɌ肪܂v
     */
    static private final MessageResource NT_BAD_PARAMETER_IN_PROPERTIES
			= new MessageResource(Yukinoshita.class, "ntBadParameterInProperties"); //$NON-NLS-1$

    /**
	 * ݒt@C̍ځg{0}h̒lsȂ߃AvP[VNX쐬ł܂łB
	 * 쐬łȂNXF{1}
	 * ̌l܂F
	 * ENX݂Ȃ(OԈĂ)
	 * EC^[tFCX⒊ۃNXȂ̂ŐłȂ
	 * EXR[vvCx[gȂ̂ŐłȂ
	 * ENX org.unitarou.yukinoshita.ApplicationĂȂ
	 * W̃AvP[VNX{2}p܂B
	 */
    static private final MessageResource MSG_BAD_APPLICATION_CLASS_NAME
    		= new MessageResource(Yukinoshita.class, "msgBadApplicationClassName"); //$NON-NLS-1$

    
    /**
     * ݒt@C̍ځg{0}h̒lsȂߕW̕Zbgݒł܂łB
	 * Zbgg{1}h݂͌̊ł͗pł܂B
	 * W̕Zbgg{2}hp܂B
     */
    static private final MessageResource MSG_BAD_DEFAULT_CHARSET
			= new MessageResource(Yukinoshita.class, "msgBadDefaultCharset"); //$NON-NLS-1$

    
    /**
     * ݒt@C̍ځg{0}h̒lsȂ߃AhIǉł܂łB
     * NXg{1}hɂĂ͖܂B
     */
    static private final MessageResource MSG_BAD_PROVIDER_CLASS_NAME
			= new MessageResource(Yukinoshita.class, "msgBadProviderClassName"); //$NON-NLS-1$

    /**
     * R}hCt@CƂĔFł܂łBsȈ:{0}
     */
    static private final MessageResource MSG_BAD_ARGUMENT_FILE_NOT_FOUND
			= new MessageResource(Yukinoshita.class, "msgBadArgumentFileNotFound"); //$NON-NLS-1$

    /**
     * vpeBt@CŋK肳Ă
     * AvP[VNXFQCNL[gapplicationhłB
     */
    static private final String PROP_KEY_APPLICATION = "application"; //$NON-NLS-1$
    
    /**
     * vpeBt@CŋK肳Ă
     * ftHg̃AvP[VNXFQCNgorg.unitarou.yukinoshita.view.jface.JFaceApplicationhłB
     */
    static private final String PROP_DEF_APPLICATION 
    		= "org.unitarou.yukinoshita.view.jface.JFaceApplication"; //$NON-NLS-1$
    
    /**
     * vpeBt@CŋK肳Ă
     * ftHg̕ZbgL[gdefaultCharsethłB
     */
    static private final String PROP_KEY_DEFAULT_CHARSET = "defaultCharset"; //$NON-NLS-1$
    
    /**
     * vpeBt@CŋK肳Ă
     * RN[gvoC_̃NX(FQCN)L[̐ړgprovider.hłB
     * ̕Ŏn܂lNXCg݂Ȃēo^܂B
     */
    static private final String PROP_KEY_PREFIX_PROVIDER = "provider."; //$NON-NLS-1$
    
    
	/** [͊Ă܂B */
	static private final MessageResource NT_MEMORY_IS_EXHAUSTED
			= new MessageResource(Yukinoshita.class, "ntMemoryIsExhausted"); //$NON-NLS-1$

	/**
	 * [͊ĂAȏ㑀𑱂ƋI邩܂.\n
	 * ̃t@CUĂA𑱂ĂB
	 */
	static private final MessageResource MSG_MEMORY_IS_EXHAUSTED
			= new MessageResource(Yukinoshita.class, "msgMemoryIsExhausted"); //$NON-NLS-1$

	/**
	 * t@CJۂɍŒKvȋ󂫃[(oCgP)B
	 * ͂Sla
	 */
	static private final long FREEMEMORY_4_OPEN_FILE = 4194304;

	/**
	 *  VXevpeB: user.name [ŨAJEgێ܂B
	 *  [U擾łȂꍇ'yukinoshita'Ɛݒ肳܂B
	 */
	static public final String USER_NAME = System.getProperty("user.name", "yukinoshita"); //$NON-NLS-1$ //$NON-NLS-2$


    static private Yukinoshita yukinoshita_s_;
    
    
    /**
     * R}hC̃AvP[VsGg[łB 
     * @param args ͑Ssgft@CƂ݂ȂēǂݍƂ܂B
     */
	static public void main(String[] args) {
		try {
		    yukinoshita_s_ = new Yukinoshita();
		    File[] files = paresFile(args);
		    yukinoshita_s_.start(files);
		    Messages.inspectUnusedMessages();
		
		} catch (Throwable e) {
			log_s_.fatal("Uncaught exception error.", e); //$NON-NLS-1$
			
		} finally {
			if (yukinoshita_s_ != null) {
				yukinoshita_s_.dispose();
			}
		}
	}


	/**
	 * argsSGFt@CƂ݂ȂāA
	 * ݂t@CFilezԂ܂B
	 * 
	 * @param args
	 * @return
	 */
    @Logging(level = Level.INFO, 
    		 contents = "args̒ɃfBNg܂݂͑ȂOƂ")  //$NON-NLS-1$
	static private File[] paresFile(String[] args) {
		List<File> files = new ArrayList<File>(args.length);
		for (String pathName : args) {
			File file = new File(pathName);
			if (file.exists() && file.isFile()) {
				files.add(file);
			} else {
				log_s_.info(MSG_BAD_ARGUMENT_FILE_NOT_FOUND.get(pathName));
			}
		}
		return files.toArray(new File[files.size()]);
	}


	/**
	 * ݎsĂ郆LmV^̃CX^XԂ܂B
	 * {@link Yukinoshita#main(String[])}ĂяoOnullԂ܂B
	 */
    static public Yukinoshita instance() {
	    return yukinoshita_s_;
	}

    /**
	 * ݎsĂ郆LmV^̃AvP[VCX^XԂ܂B
	 * {@link Yukinoshita#main(String[])}ĂяoOnullԂ܂B
	 */
    static public Application application() {
	    return yukinoshita_s_.application_;
	}
    
    /**
     * AvP[ṼReLXgԂ܂B
	 * {@link Yukinoshita#main(String[])}ĂяoO
	 * ̃\bhĂяoƁAsO({@link NullPointerException)܂B
     */
    static public Context context() {
        return yukinoshita_s_.application_.getContext();
    }
	
	
	private final Properties properties_;
	
    /**
     * AvP[V̍ŏʃCX^XłB
     */
    private Application application_;
	
	private Yukinoshita() {
	    properties_ = readProperties();
	    application_ = loadApplication();
	}
	

    /**
	 * ݒp̃vpeBt@C({@link #PROPERTIES_FILE_NAME})ǂݍ݂܂B
	 * ǂݍ݂Ɏsꍇ͋̃vpeBt@CԂ܂B
	 */
    private Properties readProperties() {
	    Properties properties = new Properties();
	    FileInputStream fileInputStream = null;
	    try {
		    fileInputStream = new FileInputStream(PROPERTIES_FILE_NAME);
		    properties.load(fileInputStream);
        
	    } catch (FileNotFoundException e) {
            log_s_.warn("Properties file is not found.", e); //$NON-NLS-1$
	        JOptionPane.showMessageDialog(null,
	                MSG_PROPERTIES_FILE_NOT_FOUND.get(PROPERTIES_FILE_NAME),
	                NT_FILE_READ_ERROR.get(),
	                JOptionPane.WARNING_MESSAGE);	        
            
        } catch (IOException e) {
            log_s_.warn("Failure to read properties file.", e); //$NON-NLS-1$
	        JOptionPane.showMessageDialog(null,
	                MSG_PROPERTIES_READ_ERROR.get(PROPERTIES_FILE_NAME),
	                NT_FILE_READ_ERROR.get(),
	                JOptionPane.WARNING_MESSAGE);	        
            
        } finally {
        	IOUtils.closeQuietly(fileInputStream);
	    }
	    return properties;
	}

    /**
     * vpeBt@CsNX쐬ĕԂ܂B
     * 쐬Ɏsꍇ͕W̃NX{@link #PROP_DEF_APPLICATION}
     * 쐬ĕԂ܂B
     */
    private Application loadApplication() {
	    String appClassName = properties_.getProperty(
	            PROP_KEY_APPLICATION, 
	            PROP_DEF_APPLICATION);

        try {
    	    Class clazz = Class.forName(appClassName);
            return (Application)clazz.newInstance();

        } catch (Exception e) {
            log_s_.warn("Failure to create an application instance.", e); //$NON-NLS-1$
        }
        JOptionPane.showMessageDialog(null,
                MSG_BAD_APPLICATION_CLASS_NAME.get(PROP_KEY_APPLICATION, appClassName, PROP_DEF_APPLICATION),
                NT_BAD_PARAMETER_IN_PROPERTIES.get(),
                JOptionPane.WARNING_MESSAGE);
        try {
            return (Application)Class.forName(PROP_DEF_APPLICATION).newInstance();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
	}
	
    /**
     * 
     */
    private void start(File[] files) {
	    setupProvider();
	    setupCharset();
	    setupContextProperties();
	    application_.getContext().loadContext();
	    application_.start(files);
    }

    /**
     * lXȕK{Provider̓o^s܂B
     * ͗L{@link Application}݂܂B
     */
    private void setupProvider() {
        Context context = application_.getContext();
        
        context.registerInterface(CoordinatesLabelProvider.class);
        context.registerInterface(VariationLabelProvider.class);
        context.registerInterface(BlockLabelProvider.class);
        context.registerInterface(RootGameTreeLabelProvider.class);
        context.registerInterface(HttpDownloader.class);

        context.registerProvider(CoordinatesLabelProvider.CONTEXT.defaultProvider().getClass());
        context.registerProvider(VariationLabelProvider.CONTEXT.defaultProvider().getClass());
        context.registerProvider(BlockLabelProvider.CONTEXT.defaultProvider().getClass());
        context.registerProvider(RootGameTreeLabelProvider.CONTEXT.defaultProvider().getClass());
        context.registerProvider(DefaultHttpDownloader.class);
        
        // uω}LvɂĂ͋lŎĝŕK{
        context.registerProvider(NoVariationProvider.class);

        for(Iterator ip = properties_.entrySet().iterator(); ip.hasNext(); ) {
            Map.Entry entry = (Map.Entry)ip.next();
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            try {
                if (key.startsWith(PROP_KEY_PREFIX_PROVIDER)) {
                    context.registerProvider(Class.forName(value));
                }
            } catch (ClassNotFoundException e) {
                log_s_.warn("Failure to set provider class.", e); //$NON-NLS-1$
                application_.openMessageDialog(
                		MessageLevel.WARNING,
                        NT_BAD_PARAMETER_IN_PROPERTIES.get(),
                        MSG_BAD_PROVIDER_CLASS_NAME.get(key, value));
            }
        }
    }

    /**
     * R[h̓o^s܂B
     * ͗L{@link Application}݂܂B
     */
    private void setupCharset() {
        Context context = application_.getContext();
        Collection<Charset> charsets = Charset.availableCharsets().values();
        context.setAttribute(
                Context.KEY_CHARSETS, 
                charsets.toArray(new Charset[charsets.size()]), 
                null);
        
        //UTF-8͐ݒ肪ԈĂƂ̕WR[h
        Charset charset = Charset.forName("UTF-8"); //$NON-NLS-1$
        String charsetName = properties_.getProperty(PROP_KEY_DEFAULT_CHARSET);
        try {
            charset = Charset.forName(charsetName);
        } catch (Exception e) {
            log_s_.warn("Failure to get default charset.", e); //$NON-NLS-1$
            application_.openMessageDialog(
            		MessageLevel.WARNING,
                    NT_BAD_PARAMETER_IN_PROPERTIES.get(),
                    MSG_BAD_DEFAULT_CHARSET.get(
                    		PROP_KEY_DEFAULT_CHARSET, 
                    		Strings.nullToNullMark(charsetName), 
                    		charset.name()));
        }
        context.setAttribute(Context.KEY_DEFAULT_CHARSET, charset, null);
    }
    
	/**
     * {@link #setupProvider()}, {@link #setupCharset()}ȊO
     * GȃReLXgݒs܂B 
     */
    private void setupContextProperties() {
        Context context = application_.getContext();

        // WŃt@C_CAO̓IWipB
        context.setAttribute(Context.FILE_DIALOG_STYLE, null);
        
        // WōŏI̋L͕\B
        context.setAttribute(Context.SHOW_LAST_MOVE_MARK, null);
        
        // Wœǂݍݒ͔ҏW[hƂ
        context.setAttribute(Context.DEFAULT_EDIT_MODE, null);
        
        // WŌ΂̍őTCY100sNZƂB
        context.setAttribute(Context.MAX_STONE_SIZE, null);
        
    }

    /**
	 * 
	 */
	private void dispose() {
		application_.dispose();
	}
    
    /** Yukinoshita ƂAvP[VԂ܂B*/
    public String getName() {
        return "Yukinoshita"; //$NON-NLS-1$
    }
    
    /** LmV^̃o[WԂ܂B */
    public String getVersion() {
        return "2 beta 8"; //$NON-NLS-1$
    }

    /** LmV^̍ŏIXVԂ܂B */
    public String getLastUpdate() {
        return "2005/12/28"; //$NON-NLS-1$
    }

	/** 
	 * [\łtrueԂ܂B
	 * Ȃꍇ̓_CAOofalseԂ܂B
	 */
	public boolean checkFreeMemory() {
	    //GC̏
	    final int GC_UPPER_LIMIT = 6;
	    int counter = 0;
	    while ( (Runtimes.availableMemory() < FREEMEMORY_4_OPEN_FILE) 
	            && (counter < GC_UPPER_LIMIT)){
	        // xfbāAx`W
	        System.gc();
	        ++counter;
	    }
	    if (counter == GC_UPPER_LIMIT) {
	    	application_.openMessageDialog(
	    				MessageLevel.WARNING,
	    				NT_MEMORY_IS_EXHAUSTED.get(), 
	    				MSG_MEMORY_IS_EXHAUSTED.get());
	        return false;
	    }
	    
	    return true;
	}

}
