/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.context;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public final class BooleanContextValue extends ContextValue {

	/**
	 * @param clazz
	 * @param key
	 * @param defaultValue
	 */
	public BooleanContextValue(Class<?> clazz, String key, boolean defaultValue) {
		super(clazz, key, new Boolean(defaultValue));
		
	}

	
	/**
	 * 
	 * @return NOT NULL
	 */
	public boolean defaultBoolean() {
		return ((Boolean)defaultValue()).booleanValue();
	}
}
