/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.context;

import java.util.Set;

import org.unitarou.ml.MessageResource;
import org.unitarou.util.Provider;



/**
 * LmV^̃AvP[VŜێ镶(ύX\)K肵܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public interface Context {
	/**
	 * t@C_CAO̎ނK肷enumłB
	 */
	enum FileDialogStyle {
		/** OSW̃_CAOw肵܂B*/
		OS,
		
		/** IWiŔՖʂ̃TlC\_CAOw肵܂B */
		ORIGINAL;

		/* (non-Javadoc)
		 * @see java.lang.Enum#toString()
		 */
		@Override
		public String toString() {
			return new MessageResource(FileDialogStyle.class, name()).get();
		}
	};
	
    /**
     * ̃L[{@link #getAttribute(String, Object)}ɓnƁA
     * ݂JVMŃT|[gĂ镶Zbg̔z({@link java.nio.charset.Charset}[])Ԃ܂B
     */
    String KEY_CHARSETS = Context.class.getName() + ".charsets"; //$NON-NLS-1$
    
    
    /**
     * ̃L[{@link #getAttribute(String, Object)}ɓnƁA
     * ݂̃ftHg̕Zbg̃CX^X{@link java.nio.charset.Charset}Ԃ܂B
     */
    String KEY_DEFAULT_CHARSET = Context.class.getName() + ".defaultCharset"; //$NON-NLS-1$
   
    
    /**
     * ̃L[{@link #getAttribute(String, Object)}ɓnƁA
     * t@C_CAǑ`(^{@link FileDialogStyle})Ԃ܂B
     */
    ContextValue FILE_DIALOG_STYLE = new ContextValue(
    		Context.class, "fileDialogStyle", FileDialogStyle.ORIGINAL); //$NON-NLS-1$

    
    /**
     * ̃L[{@link #getAttribute(String, Object)}ɓnƁA
     * ۑɊgq{@link org.unitarou.sgf.Sgfs#EXTENSION}
     * ύX邩ǂ̃tO(^{@link Boolean})Ԃ܂B<br>
     * ftHgTruełB
     */
    BooleanContextValue APPEND_SGF_EXTENSION_IN_SAVE = new BooleanContextValue (
    		Context.class, "appendSgfExtenstionInSave", true); //$NON-NLS-1$

    /**
     * ̃L[{@link #getAttribute(String, Object)}ɓnƁA
     * ǂݍݒɕҏW[hɂ邩ǂ̃tO(^{@link Boolean})Ԃ܂B
     */
    ContextValue DEFAULT_EDIT_MODE	= new ContextValue(
    		Context.class, "defaultEditMode", Boolean.FALSE); //$NON-NLS-1$
    
    /**
     * ̃L[{@link #getAttribute(String, Object)}ɓnƁA
     * ŏIL\邩ǂ̃tO(^{@link Boolean})Ԃ܂B
     */
    ContextValue SHOW_LAST_MOVE_MARK	= new ContextValue(
    		Context.class, "showLastMoveMark", Boolean.TRUE); //$NON-NLS-1$
    
    /**
     * ̃L[{@link #getAttribute(String, Object)}ɓnƁA
     * ΂̍őTCY(sNZA^{@link Integer})Ԃ܂B
     * ftHg100sNZłB
     */
    IntContextValue MAX_STONE_SIZE = new IntContextValue(
    		Context.class, "maxStoneSize", 5, 100, 200); //$NON-NLS-1$, 

    /**
     * ̃L[{@link #getAttribute(String, Object)}ɓnƁA
     * eLXgҏWɃt@CXV܂ł̕Ԃ܂B
     * ftHg5łB
     */
    IntContextValue CHAR_LENGTH_PER_UPDATE = new IntContextValue(
    		Context.class, "charLengthPerUpdate", 1, 5, 1000); //$NON-NLS-1$, 
    
    
    /**
     * AvP[VpvoC_[(ւ\ȃNX)̃C^[tFCXo^܂B
     * 
     * @param providerInterface o^voC_[BKJavaInterfalsełKv܂B
     * @return VKɓo^ꂽꍇtrueBɓo^Ăꍇfalse
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    boolean registerInterface(Class<?> providerInterface);
    
    /**
     * ݓo^ĂC^[tFCX̔zԂ܂B
     * 
     * @return ݓo^ĂC^[tFCX̔zB<code>null</code>͕ԂȂB
     */
    Class<?>[] getInterfaces();

    /**
     * voC_[NXo^܂B
     * {@link #registerInterface(Class)}œo^ꂽ
     * C^[tFCXƂ̑Ή͎Iɍs܂B
     * Ȃ킿AŌsA\ProviderInterfaceSĂɓo^܂B
     * 
     * @param provider o^NX
     * @return ̎NXo^ꂽProviderInterface̔zB
     *          1o^łȂꍇ͗vfO̔zԂAnull͕ԂȂB
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    Class<?>[] registerProvider(Class<?> provider);
    
    
    /**
     * ReLXgǂݏo܂B
     * {@link #registerInterface(Class)},{@link #registerProvider(Class)}
     * ĂяoȂƃReLXg͓ǂݏo܂B
     */
    void loadContext();

    
    /**
     * ReLXgۑ܂B
     */
    void saveContext();

    
    /**
     * w肳ꂽXR[vŗpC^[tFCX̎voC_[w肵܂B
     * ^`FbNsȊO {@link #setAttribute(String, Object, Object)}ƓłB
     * 
     * @param providerInterface
     * @param provider
     * @param scope
     * @throws org.unitarou.lang.NullArgumentException providerInterfaceprovidernull̏ꍇB
     * @throws IllegalArgumentException providerproviderInterfalsẽTuNXłȂƂAprovider̎̉ɎsꍇBB
     * 
     */
    void setProvider(Class<?> providerInterface, Class<?> provider, Object scope);
    
    
    /**
     * ݓo^ĂProvider̒ŁA
     * providerInterfaceɑΉSNX̃CX^XzԂ܂B
     * ԂCX^X́Ã\bhĂяo邽тɐVKɍ쐬܂B
     * ܂CX^X̍쐬ɂProvider̊eftHgRXgN^
     * tNVgČĂяoĂ܂B
     * ftHgRXgN^ȂProviderɂĂ͖A
     * ʂ̔zɂ͓܂B
     * 
     * @param providerInterface
     * @return providerInterfaceɓo^ĂproviderCX^X̔zB
     *          1CX^XłȂꍇ͗vfO̔zԂAnull͕ԂȂB
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    <T extends Provider> T[] getProviders(Class<T> providerInterface);
    
    
    /**
     * scopeŎw肳ꂽXR[vŁA
     * providerInterfaceɑΉprovider̃CX^XԂ܂B
     * ܂scope͐eq֌WĂAw肳ꂽscopeɓo^ꍇ
     * eƋK肳ꂽXR[v̒lԂ܂B
     * scopenull̏ꍇAAvP[VxɂȂ܂B 
     * ԂCX^X́Ã\bhĂяoiKő݂Ȃꍇ̂ݐVKɍ쐬܂B
     * ܂CX^X̍쐬ɂ͊Yprovider̃ftHgRXgN^
     * tNVgČĂяoĂ܂B
     * 
     * @param providerInterface
     * @param scope
     * @return providerɓo^ĂConcrete providerCX^XBnull͕ԂȂB
     * @throws org.unitarou.lang.NullArgumentException providernull̏ꍇB
     * @throws IllegalStateException ߂lɂvoC_[NX
     *          ftHgRXgN^ŐłȂꍇA
     * @@@@@providerInterfaceproviderȂꍇ
     */
    <T extends Provider> T getProvider(Class<T> provider, Object scope);

    
    /**
     * scopeŎw肳ꂽXR[vŁAkeyattributȇgݒ肵܂B
     * scopenull̏ꍇAAvP[VxɂȂ܂B 
     * ܂scope͎QƂœo^܂BOQƂȂscopew肵ꍇA
     * ₩ɂ̃XR[v̓NA[܂B
     * 
     * @param key
     * @param attribute
     * @param scope
     * @throws org.unitarou.lang.NullArgumentException scopeȊÖnullꍇB
     */
    void setAttribute(String key, Object attribute, Object scope);
    
	/**
     * scopeŎw肳ꂽXR[vŁAattributeݒ肵܂B<br>
     * {@link ContextValue#id()}{@link ContextValue#defaultValue()}p܂B
     * 
	 * @param attribute
	 * @param scope
     * @throws org.unitarou.lang.NullArgumentException attribute<code>null</code>̏ꍇB
	 */
	void setAttribute(ContextValue attribute, Object scope);
    
	
	/**
	 * AvP[VxŕێĂSL[Ԃ܂B
	 * @return
	 */
	String[] rootKeys();
	
    /**
     * scopeŎw肳ꂽXR[vŁAkeyɑΉattributeԂ܂B
     * scopenull̏ꍇAAvP[VxɂȂ܂B
     * ܂scope͐eq֌WĂAw肳ꂽscopeɓo^ꍇ
     * eƋK肳ꂽXR[v̒lԂ܂B
     * NXK肵Ȃ΂ȂȂXR[v
     * {@link org.unitarou.sgf.RootGameTree}{@link org.unitarou.sgf.Collection}łB
     * ȊOɂĂ̓AvP[VxɂȂ܂B
     * ł݂ȂꍇnullԂ܂B
     * 
     * @param key
     * @param scope
     * @return keyɑΉscopeŗLattribute
     * @throws org.unitarou.lang.NullArgumentException providernull̏ꍇB
     */
    Object getAttribute(String key, Object scope);
    
    
    /**
     * scopeŎw肳ꂽXR[ṽReLXgԂ܂B
     * @param scope null܂B
     * @return scopeŎw肳ꂽXR[vł̃ReLXgB
     */
    CurrentContext getCurrent(Object scope);
    
    
    /**
     * scopeŎw肳ꂽXR[ṽReLXgSăNA[܂B
     * @param scope
     * @return ReLXgɕێĂL[̔z
     */
    Object[] clearCurrent(Object scope);
    
    
	/**
	 * listenerQƂŕێ܂B
	 * Contextł͎QƂŕێ邱Ƃ܂B
	 * ČĂяoł͋QƂŕێKv܂B
	 * listernernull̏ꍇ͉܂B
	 */
    void addListener(ContextListener listener);
    
    
	/**
	 * o^Ălistener폜܂B
	 * listener݂ȂꍇAnull̏ꍇO͑o܂B
	 */
    void removeListener(ContextListener listener);
    
    
    /**
     * keys̑ύXꂽƂʒmA
     * {@link ContextListener#attributeChanged(Set)}Cxg𔭐܂B
     * keys̒l{ɕύX̂ɂĂ̓`FbN܂B
     * 
     * @param keys
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    void fireAttributeChanged(String[] keys);

}

 
