/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.context;

import org.unitarou.lang.Classes;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;

/**
 * ReLXg̕ێpKEYƃftHglێ܂B<br>
 * ReLXg̐{@link org.unitarou.ml.MessageResource}
 * œpbP[Wɂmessages.propertiesɋLڂ܂B
 * ȂAl[Xy[X{@link org.unitarou.ml.MessageResource}Ɠł̂
 * NXœL[gȂ悤ɒӂĂB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class ContextValue implements NameDisplayable {
	
	private final String id_;
	private final Class<?> clazz_;
	private final MessageResource messageResource_;
	private final Object defaultValue_;
	
	/**
	 * classpbP[Wkeyid\āAdefaultValueێ܂B
	 * 
	 * @param clazz {@link MessageResource}̃pbP[Wwp
	 * @param key
	 * @param defaultValue
	 * @throws <code>null</code>ꍇB
	 */
	public ContextValue(Class<?> clazz, String key, Object defaultValue) {
		super();
		ArgumentChecker.throwIfNull(clazz, key, defaultValue);
		clazz_ = clazz;
		messageResource_ = new MessageResource(clazz, key);
		id_ = Classes.packageName(clazz) + '.' + messageResource_.getKey();
		defaultValue_ = defaultValue;
		Context context = Yukinoshita.context();
		// [gɒlݒ̏ꍇ̂݁AftHglo^܂B
		if (context.getAttribute(id_, null) == null) {
			context.setAttribute(id_, defaultValue_, null);
		}
	}

	public String id() {
		return id_;
	}
	
	/**
	 * RXgN^Ŏw肵{@link Class}Ԃ܂B
	 * @return
	 */
	public Class<?> getContextClass() {
		return clazz_;
	}
	
	/**
	 * ̃ReLXgl̃ftHgԂ܂B
	 * @return
	 */
	public Object defaultValue() {
		return defaultValue_;
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.lang.NameDisplayable#getDisplayName()
	 */
	public String displayName() {
		return messageResource_.get();
	}
}
