/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.context;

import java.io.File;

import org.unitarou.util.Provider;

/**
 * ̃XR[vɐꂽReLXgłB
 * 
 *
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public interface CurrentContext {
    /**
     * ȂReLXgłB
     */
    CurrentContext nullContext = new DefaultContext.NullCurrentContext();
    
    /**
     * providerInterfaceɑΉ{@link Provider}̃CX^XԂ܂B
     * ԂCX^X́Ã\bhĂяoiKő݂Ȃꍇ̂ݐVKɍ쐬܂B
     * ܂CX^X̍쐬ɂ͊Yprovider̃ftHgRXgN^
     * tNVgČĂяoĂ܂B
     * 
     * @param providerInterface
     * @return providerɓo^ĂConcrete providerCX^XBnull͕ԂȂB
     * @throws org.unitarou.lang.NullArgumentException providerInterfacenull̏ꍇB
     * @throws IllegalArgumentException ߂lɂvoC_[NX
     *          ftHgRXgN^ŐłȂꍇA
     * @@@@@providerInterfaceproviderȂꍇ
     */
    <T extends Provider> T getProvider(Class<T> providerInterface);

    /**
     * pC^[tFCX̎voC_[w肵܂B
     * 
     * @param providerInterface
     * @param provider
     * @throws org.unitarou.lang.NullArgumentException providerInterfaceprovidernull̏ꍇB
     * @throws IllegalArgumentException providerproviderInterfalsẽTuNXłȂƂAprovider̎̉ɎsꍇB
     */
    <T extends Provider> void setProvider(Class<T> providerInterface, Provider provider);

    /**
     * keyu[lԂ܂B
     * @param key
     * @return
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     * @throws IllegalStateException keyɕRl݂ȂAbooleanlłȂꍇB
     */
    boolean getBoolean(String key);
    
    /**
     * keyu[lԂ܂B
	 * l擾łȂꍇ{@link BooleanContextValue#defaultBoolean()}Ԃ܂B
	 * @param value
     * @return
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     * @throws IllegalStateException keyɕRl݂ȂAbooleanlłȂꍇB
     */
    boolean getBoolean(BooleanContextValue value);

    /**
	 * value琮lԂ܂B<br> 
	 * l擾łȂꍇ{@link IntContextValue#defaultInt()}Ԃ܂B
	 * 
	 * @param value
	 * @return
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     * @throws IllegalStateException keyɕRl݂ȂAintlłȂꍇB
	 */
	int getInteger(IntContextValue value);
	
	/**
	 * key琮lԂ܂BlꍇdefaultValueԂ܂B
	 * 
	 * @param key
	 * @return
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	int getInteger(String key, int defaultValue);

	/**
	 * keyƐlR܂B
	 * @param string
	 * @param x
	 * @param object
	 */
	void setInteger(String key, int value);

	/**
	 * key琮l̔zԂ܂B
	 * lꍇz̗vfdefaultValueƈقȂꍇdefaultValuê܂ܕԂ܂B
	 * @param key
	 * @param defaultValue
	 * @return
	 */
	int[] getIntArray(String key, int[] defaultValue);

	/**
	 * value琮̔zԂ܂B<br> 
	 * l擾łȂꍇ{@link IntArrayContextValue#defaultIntArray()}Ԃ܂B
	 * @param value
	 * @return
	 */
	int[] getIntArray(IntArrayContextValue value);

	/**
	 * key琮l̔zR܂B
	 * @param string
	 * @param is
	 * @throws org.unitarou.lang.NullArgumentException valuenull̏ꍇ
	 */
	void setIntArray(String key, int[] value);

	/**
	 * value{@link File}CX^XԂ܂B<br>
	 * lReLXg擾łȂꍇ{@link FileContextValue#defaultFile()}Ԃ܂B
	 * 
	 * @param value
	 * @return
	 */
	File getFile(FileContextValue value);

	/**
	 * key{@link File}Rt܂B
	 * @param key
	 * @param file
	 */
	void setFile(String key, File file);

}
