/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.context;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.util.StrategyRegistrar;
import org.unitarou.util.WeakedList;

/**
 * WIȃReLXgłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class DefaultContext implements Context {
	
    /**
     * ȂReLXgłB 
     */
    static class NullCurrentContext implements CurrentContext {

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.CurrentContext#getProvider(java.lang.Class)
         */
        public <T extends Provider> T getProvider(Class<T> providerInterface) {
            return null;
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.CurrentContext#setProvider(java.lang.Class, org.unitarou.yukinoshita.view.provider.Provider)
         */
        public <T extends Provider> void setProvider(
        		Class<T> providerInterface, Provider provider) 
        {
        	// ܂
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.CurrentContext#getBoolean(java.lang.Object)
         */
        public boolean getBoolean(String key) {
            return false;
        }

        /* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#getBoolean(org.unitarou.yukinoshita.context.BooleanContextValue)
		 */
		public boolean getBoolean(BooleanContextValue value) {
			return false;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#getInteger(org.unitarou.yukinoshita.context.IntContextValue)
		 */
		public int getInteger(IntContextValue resource) {
			return 0;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#getInteger(java.lang.String, int)
		 */
		public int getInteger(String key, int defaultValue) {
			return 0;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#setInteger(java.lang.String, int)
		 */
		public void setInteger(String key, int value) {
			// ȂB
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#getIntArray(java.lang.String, int[])
		 */
		public int[] getIntArray(String key, int[] defaultValue) {
			return defaultValue;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#setIntArray(java.lang.String, int[])
		 */
		public void setIntArray(String key, int[] value) {
			// ȂB
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#getIntArray(org.unitarou.yukinoshita.context.IntArrayContextValue)
		 */
		public int[] getIntArray(IntArrayContextValue size) {
			ArgumentChecker.throwIfNull(size);
			return size.defaultIntArray();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#getFile(org.unitarou.yukinoshita.context.FileContextValue)
		 */
		public File getFile(FileContextValue value) {
			ArgumentChecker.throwIfNull(value);
			return value.defaultFile();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#setFile(java.lang.String, java.io.File)
		 */
		public void setFile(String key, File file) {
			// ȂB
		}
    }

    
    /** XR[v̍ŏʂ\L[łB */
    private final Object rootScope_;

    /**
     * voC_[ێ邽߂̃WXgłB
     */
    private final StrategyRegistrar strategyRegistrar_;
    
    /**
     * ^[Object:child, Object:parent]łB
     * XR[v̐eq֌WL^܂B
     */
    private final WeakHashMap<Object, Object> scopeMap_;
    
    /**
     * ^[Object:scope, Map[String:key, Object:value]]łB
     * w肳ꂽXR[vłkey:valueێ܂B
     */
    private final WeakHashMap<Object, Map<String, Object>> attributeMap_;
    
    
    /**
     * ^[Object:scope, {@link CurrentContext}:currentContext]łB
     */
    private final WeakHashMap<Object, CurrentContext> contextMap_;
    
	/**
	 * ^[{@link ContextListener}]łB
	 */
	private final WeakedList<ContextListener> listeners_;	

	/**
     * 
     */
    public DefaultContext() {
        super();
        rootScope_ = new Object();
        strategyRegistrar_ = new StrategyRegistrar();
        scopeMap_ = new WeakHashMap<Object, Object>();
        attributeMap_ = new WeakHashMap<Object, Map<String, Object>>();
        attributeMap_.put(rootScope_, new HashMap<String, Object>()); 
        contextMap_ = new WeakHashMap<Object, CurrentContext>();
        listeners_ = new WeakedList<ContextListener>();
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.Context#registerProvider(java.lang.Class)
     */
    public boolean registerInterface(Class provider) {
        ArgumentChecker.throwIfNull(provider);
        return strategyRegistrar_.registerStrategy(provider);
    }

    /* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.context.Context#getInterfaces()
	 */
	public Class<?>[] getInterfaces() {
		return strategyRegistrar_.getStrategies();
	}
  
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.Context#registerConcreteProvider(java.lang.Class)
     */
    @SuppressWarnings("unchecked") //$NON-NLS-1$
	public Class<?>[] registerProvider(Class<?> concreteProvider) {
        ArgumentChecker.throwIfNull(concreteProvider);
        Class<?>[] providers = strategyRegistrar_.registerConcreteStrategy(concreteProvider);
        for (Class clazz : providers) {
        	// voC_̃[fBOĂB
        	getProvider(clazz, null);
        }
        return providers;
    }

	/**
	 * ̃NXł̓f[^load^save͍s܂B
	 * @see org.unitarou.yukinoshita.context.Context#loadContext()
	 */
	public void loadContext() {
		// Ȃ
	}
	
	/**
	 * ̃NXł̓f[^load^save͍s܂B
	 * @see org.unitarou.yukinoshita.context.Context#saveContext()
	 */
	public void saveContext() {
		// Ȃ
	}

  
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.Context#setProvider(java.lang.Class, java.lang.Class, java.lang.Object)
     */
    public void setProvider(Class<?> providerInterface, Class<?> provider, Object scope) {
        ArgumentChecker.throwIfNull(providerInterface, provider);
        if (!providerInterface.isAssignableFrom(provider)) {
            throw new IllegalArgumentException(
                    "Interface mismatch: "  //$NON-NLS-1$
                    + providerInterface + " is no assignable from " + provider); //$NON-NLS-1$
        }
        Class[] providers = strategyRegistrar_.getConcreteStrategies(providerInterface);
        for (int i = 0; i < providers.length; ++i) {
            if (providers[i].equals(provider)){
                setProviderImpl(providerInterface, provider, scope);
                return;
            }
        }
        setProviderImpl(providerInterface, provider, scope);
    }
    
    /**
     * ۂprovider𑮐lƂēo^郁\bhłB
     * 
     * @param providerInterface
     * @param provider
     * @param scope
     * @throws IllegalArgumentException provider̃CX^XɎsꍇ
     */
    private void setProviderImpl(Class providerInterface, Class provider, Object scope) {
        try {
            setAttribute(providerInterface.getName(), provider.newInstance(), scope);
        } catch (InstantiationException e) {
            throw new IllegalArgumentException("Instantiation failure:" + provider); //$NON-NLS-1$
        } catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Constructer access failure:" + provider); //$NON-NLS-1$
        }
    }
    
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.Context#getConcreteProviders(java.lang.Class)
     */
    public <T extends Provider> T[] getProviders(Class<T> provider) {
        ArgumentChecker.throwIfNull(provider);
        return strategyRegistrar_.getConcreteStrategyInstances(provider);
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.Context#getConcreteProvider(java.lang.Class, java.lang.Object)
     */
    public <T extends Provider> T getProvider(Class<T> provider, Object scope) {
        ArgumentChecker.throwIfNull(provider);
        
        T ret = getProviderFromAttribute(provider, scope);
        if (ret != null) {
            return ret;
        }
        
        return getProviderByCreateInstance(provider, scope);
    }
    
    @SuppressWarnings("unchecked") //$NON-NLS-1$
	private <T extends Provider> T getProviderFromAttribute(Class<T> provider, Object scope) {
        Object concreteProvider = getAttribute(provider.getName(), scope);
        if (concreteProvider == null) {
            return null;
        }
        if (!provider.isAssignableFrom(concreteProvider.getClass())) {
            throw new IllegalStateException(
                    "Bad attribute for " + provider //$NON-NLS-1$
                    + ". " + concreteProvider + " is not an instance of " + Provider.class);  //$NON-NLS-1$//$NON-NLS-2$
                    		
        }
        return (T)concreteProvider;
    }
    
    /**
     * XR[vɃvoC_[݂ȂƂOɁA
     * VKɃCX^X쐬ēo^ÃCX^XԂ܂B
     * @param provider
     * @param scope
     * @return
     */
    private <T> T getProviderByCreateInstance(Class<T> provider, Object scope) {
        Class<T>[] providers = strategyRegistrar_.getConcreteStrategies(provider);
        if (providers.length == 0) {
            throw new IllegalStateException("There are any concrete providers for " + provider); //$NON-NLS-1$
        }
        try {
        	T ret = providers[0].newInstance();
            setAttribute(provider.getName(), ret, scope);
            return ret;
            
        } catch (ClassCastException e) {
            throw new IllegalStateException(
                    "Bad attribute for " + provider //$NON-NLS-1$
                    + ". " + providers[0] + " is not an instance of " + Provider.class);  //$NON-NLS-1$//$NON-NLS-2$
            
        } catch (InstantiationException e) {
            throw new IllegalStateException("Provider " + providers[0] + " has no default constructer."); //$NON-NLS-1$ //$NON-NLS-2$
            
        } catch (IllegalAccessException e) {
            throw new IllegalStateException("Default constructer for provider " + providers[0] + " is not public scope."); //$NON-NLS-1$ //$NON-NLS-2$
        }
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.Context#setConcreteProvider(java.lang.Class, java.lang.Object, java.lang.Object)
     */
    public void setAttribute(String key, Object attribute, Object scope) {
        ArgumentChecker.throwIfNull(key, attribute);
        
        scope = toRootScopeIfNull(scope);
        if (scope instanceof Collection) {
            scopeMap_.put(scope, rootScope_);
        } else if (scope instanceof RootGameTree) {
            Collection collection = findCollection((RootGameTree)scope);
            if (collection != null) {
                scopeMap_.put(collection, scope);
            }
        }
        Map<String,Object> map = attributeMap_.get(scope);
        if (map == null) {
            map = new HashMap<String,Object>();
            attributeMap_.put(scope, map);
        }
        map.put(key, attribute);
    }

    /* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.context.Context#setAttribute(org.unitarou.yukinoshita.context.ContextValue, java.lang.Object)
	 */
	public void setAttribute(ContextValue attribute, Object scope) {
		ArgumentChecker.throwIfNull(attribute);
		setAttribute(attribute.id(), attribute.defaultValue(), scope);
	}

    /**
     * scopenull̏ꍇ{@link #rootScope_}ɕϊ܂B
     */
    private Object toRootScopeIfNull(Object scope) {
        return (scope == null) ? rootScope_ : scope;
    }
    
    /**
     * tree̐e{@link Collection}{@link #scopeMap_}̒T܂B
     * ȂꍇnullԂ܂B
     * @param tree
     * @return
     */
    private Collection findCollection(RootGameTree tree) {
        for (Iterator ip = scopeMap_.keySet().iterator(); ip.hasNext();) {
            Object value = ip.next();
            if (!(value instanceof Collection)) {
                continue;
            }
            Collection collection = (Collection)value;
            for (int i = 0; i < collection.size(); ++i) {
                if (tree == collection.get(i)) {
                    return collection;
                }
            }
        }
        return null;
    }

    /* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.context.Context#rootKeys()
	 */
	public String[] rootKeys() {
		Map<String, Object> map = attributeMap_.get(rootScope_);
		return map.keySet().toArray(new String[map.size()]);
	}

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.Context#getConcreteProvider(java.lang.Class, java.lang.Object)
     */
    public Object getAttribute(String key, Object scope) {
        ArgumentChecker.throwIfNull(key);
        scope = toRootScopeIfNull(scope);
        Map rootMap = attributeMap_.get(rootScope_);
        Map map; 
        Object ret;
        do {
            map = findMap(scope);
            ret = map.get(key);
            if (ret != null) {
                return ret;
            }
            scope = scopeMap_.get(scope);
            scope = toRootScopeIfNull(scope);
        } while (map != rootMap);
        return ret;
    }
    
    /**
     * scopeɑΉkey-value}bvԂ܂B
     * ݂Ȃꍇ͐eɂǂ܂B 
     */
    private Map findMap(Object scope) {
        Map map = attributeMap_.get(scope);
        while (map == null) {
            scope = scopeMap_.get(scope);
            scope = toRootScopeIfNull(scope);
            map = attributeMap_.get(scope);
        }
        return map;
    }
    
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.Context#getCurrent(java.lang.Object)
     */
    public CurrentContext getCurrent(Object scope) {
        scope = toRootScopeIfNull(scope);
        CurrentContext ret = contextMap_.get(scope);
        if (ret == null) {
            ret = new CurrentContextImpl(scope);
            contextMap_.put(scope, ret);
        }
        return ret;
    }
    
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.Context#clearCurrent(java.lang.Object)
     */
    public Object[] clearCurrent(Object scope) {
        scope = toRootScopeIfNull(scope);
        scopeMap_.remove(scope);
        Map map = attributeMap_.remove(scope);
        contextMap_.remove(scope);
        
        if (map == null) {
            return new Object[0]; 
        }
        return map.keySet().toArray();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.Context#addListener(org.unitarou.yukinoshita.ContextListener)
     */
    public void addListener(ContextListener listener) {
        if (listener == null) {
            return;
        }
        listeners_.add(listener);
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.Context#removeListener(org.unitarou.yukinoshita.ContextListener)
     */
    public void removeListener(ContextListener listener) {
        listeners_.remove(listener);
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.Context#fireAttributeChanged(java.lang.Object[])
     */
    public void fireAttributeChanged(String[] keys) {
        ArgumentChecker.throwIfNull((Object)keys);
        
        Set<String> set =new HashSet<String>(Arrays.asList(keys));
        Set<String> keySet = Collections.unmodifiableSet(set);
		ContextListener[] listeners = listeners_.toArray(new ContextListener[0]);
		for (int i = 0; i < listeners.length; ++i) {
		    listeners[i].attributeChanged(keySet);	
		}
    }
    
    
    /**
     * {@link DefaultContext#getCurrent(Object)}ŕԂNXłB
     * XR[vQƂŕێ̂ŁAOŃXR[vGCꂽuԂɁA
     * ̃CX^X̓ReLXg̃[g悤ɂȂ܂B 
     */
    private class CurrentContextImpl implements CurrentContext {
        private final WeakReference<Object> reference_;
        private CurrentContextImpl(Object scope) {
            reference_ = new WeakReference<Object>(scope);
        }
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.CurrentContext#getProvider(java.lang.Class)
         */
        public <T extends Provider> T getProvider(Class<T> providerInterface) {
            return DefaultContext.this.getProvider(providerInterface, reference_.get());
        }
        
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.CurrentContext#setProvider(java.lang.Class, java.lang.Class)
         */
        public <T extends Provider> void setProvider(
        		Class<T> providerInterface, Provider provider) 
        {
            setAttribute(providerInterface.getName(), provider, reference_.get());
        }
        
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.CurrentContext#getBoolean(java.lang.Object)
         */
        public boolean getBoolean(String key) {
            Object value = getAttribute(key, reference_.get());
            if (value == null || !(value instanceof Boolean)) {
            	throwIllegalStateException(key, value);
            }
            return ((Boolean)value).booleanValue();
        }
        
		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#getBoolean(org.unitarou.yukinoshita.context.BooleanContextValue)
		 */
		public boolean getBoolean(BooleanContextValue value) {
			ArgumentChecker.throwIfNull(value);
            Object attr = getAttribute(value.id(), reference_.get());
            if (attr == null || !(attr instanceof Boolean)) {
            	return value.defaultBoolean();
            }
            return ((Boolean)attr).booleanValue();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#getInteger(org.unitarou.yukinoshita.context.IntContextValue)
		 */
		public int getInteger(IntContextValue resource) {
			ArgumentChecker.throwIfNull(resource);
            Object value = getAttribute(resource.id(), reference_.get());
            if (value == null || !(value instanceof Integer)) {
            	return resource.defaultInt();
            }
            return ((Integer)value).intValue();
		}
		
		
		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#getInteger(java.lang.String, int)
		 */
		public int getInteger(String key, int defaultValue) {
            Object value = getAttribute(key, reference_.get());
            if (value == null) {
            	return defaultValue;
            }
            if (!(value instanceof Integer)) {
            	throwIllegalStateException(key, value);
            }
            
            return ((Integer)value).intValue();
		}
		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#setInteger(java.lang.String, int)
		 */
		public void setInteger(String key, int value) {
			setAttribute(key, new Integer(value), reference_.get());
		}
		
		
		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#getIntArray(java.lang.String, int[])
		 */
		public int[] getIntArray(String key, int[] defaultValue) {
			Object value = getAttribute(key, reference_.get());
            if (value == null) {
            	return defaultValue;
            }
            if (!(value instanceof int[])) {
            	throwIllegalStateException(key, value);
            }
			return (int[])value;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#getIntArray(org.unitarou.yukinoshita.context.IntArrayContextValue)
		 */
		public int[] getIntArray(IntArrayContextValue value) {
			ArgumentChecker.throwIfNull(value);
			return getIntArray(value.id(), value.defaultIntArray());
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#setIntArray(java.lang.String, int[])
		 */
		public void setIntArray(String key, int[] value) {
			ArgumentChecker.throwIfNull(value);
			setAttribute(key, value, reference_.get());			
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#getFile(org.unitarou.yukinoshita.context.FileContextValue)
		 */
		public File getFile(FileContextValue value) {
			ArgumentChecker.throwIfNull(value);
            Object obj = getAttribute(value.id(), reference_.get());
            if (obj == null) {
            	return value.defaultFile();
            }
            if (!(obj instanceof File)) {
            	throwIllegalStateException(value.id(), value);
            }
            return (File)obj;
		}
		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.context.CurrentContext#setFile(java.lang.String, java.io.File)
		 */
		public void setFile(String key, File file) {
			ArgumentChecker.throwIfNull(file);
			setAttribute(key, file, reference_.get());			
		}

		/**
		 * keyɑ΂valuesƂ{@link IllegalStateException}𓊂܂B
		 * @param key
		 * @param value
		 */
		private void throwIllegalStateException(String key, Object value) {
            throw new IllegalStateException(
                    "Bad value. key=\'" + key  //$NON-NLS-1$
                    + "\', value=\'" + value + "\'"); //$NON-NLS-1$ //$NON-NLS-2$
		}
    }
}
