/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.context;

/**
 * int̔zێ{@link org.unitarou.yukinoshita.context.ContextValue}łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class IntArrayContextValue extends ContextValue {

	private final int[] defaultValue_;

	/**
	 * @param clazz
	 * @param key
	 * @param defaultValue
	 */
	public IntArrayContextValue(Class<?> clazz, String key, int... defaultValue) {
		super(clazz, key, defaultValue);
		defaultValue_ = new int[defaultValue.length];
		System.arraycopy(defaultValue, 0, defaultValue_, 0, defaultValue_.length);
	}
	

	public int[] defaultIntArray() {
		int[] ret = new int[defaultValue_.length];
		System.arraycopy(defaultValue_, 0, ret, 0, ret.length);
		return ret;
	}
}
