/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.context;

import org.unitarou.ml.MessageResource;

/**
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class IntContextValue extends ContextValue {
	
	/**
	 * u{0}ɂ{1}`{2}̐lw肵ĉBv
	 */
	static private final MessageResource MSG_ERROR
			= new MessageResource(IntContextValue.class, "msgError"); //$NON-NLS-1$
	
	private final int min_;
	
	private final int max_;
	
	private final int def_;

	/**
	 * @param clazz
	 * @param key
	 * @param defaultValue
	 */
	public IntContextValue(
			Class<?> clazz, String key,int min, int def, int max) {
		super(clazz, key, new Integer(def));
		min_ = min;
		max_ = max;
		def_ = def;
		if ((def_ < min_ ) || (max_ < def_)) {
			throw new IllegalArgumentException();
		}
	}
	
	public int minInt() {
		return min_;
	}
	public int defaultInt() {
		return def_;
	}

	/**
	 * {@link #MSG_ERROR}ɒlw肵ĕԂ܂B
	 * @return
	 */
	public String errorMessage() {
		return MSG_ERROR.get(displayName(), new Integer(min_), new Integer(max_));
	}
}
