/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.events;

import java.util.Set;

import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.view.cmd.Command4View;

/**
 * ViewslXȑControllerɒʒmƂ𒇉܂B
 * ʒm鑀͑傫āF
 * <ol>
 * <li>Controller̓Ԃ̕ύXɔ́A</li>
 * <li>View̕\Ԃ̐؂ւɔ́A</li>
 * <li>Model̑Ɋւ́A</li>
 * </ol>
 * 3ނ݂܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public interface EventBroker {
    /** Null ObjectłB */
    EventBroker NULL_BROKER = NullEventBroker.instance_s_;
    
    /**
     * Controller̎wɂModel̕ύX̒ʒm󂯂ViewCX^Xo^܂B
     * {@link Adaptable#getAdapter(Class)}𗘗p̂ŁA
     * view͎󂯎肽̌^w肷Kv܂B
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    void addView(Adaptable view);
    
    /**
     * {@link #addView(Adaptable)}œo^A_v^[
     * 폜܂B
     */
    void removeView(Adaptable view);
    
    
    /**
     * {@link StateHandler}̃CX^Xɓo^܂B
     * o^ꂽeventHandleŕA{@link #connect(GameType, boolean)}
     * gameTypeisEditModełƂɐڑ܂B
     */
    void register(GameType gameType, boolean isEditMode, StateHandler eventHandler);
    
    /**
     * clazzĂ郊Xi[̏WԂ܂B
     * ʂĕԂ܂B
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    <T> Set<T> getListeners(Class<T> clazz);

    /**
     * ŕێĂ{@link StateHandler}̐ڑ؂ւ܂B
     * ȑO{@link StateHandler}{@link #disconnect()}܂B
     * @param gameType ڑ͂̒lɂČ肳܂B
     * @param isEditMode trueɂƐ؂ւɕҏWԂɂȂ܂B 
     */
    void connect(GameType gameType, boolean isEditMode);


    /**
     * ݂{@link StateHandler}̐ڑؒf܂B
     */
    void disconnect();
    
    
    /** 
     * {@link #connect(GameType, boolean)}Ă
     * {@link StateHandler}Ԃ܂B
     * x{@link #register(GameType, boolean, StateHandler)}ĂȂꍇȂǂ
     * nullԂ邱Ƃ܂B
     */
    StateHandler getCurrentStateHander();
    
    /**
     * {@link org.unitarou.yukinoshita.model.EditableNodeList}^[QbgƂ
     * R}hs܂B
     * @param command sR}hBĂяoiKł
     *         {@link Command4NodeList#getEditableNodeList()}<code>null</code>ł悢B
     *         ʒmœK؂Ɋ蓖ĂƏȂB
     * @throws org.unitarou.lang.NullArgumentException commandnull̏ꍇ
     */
    void executeCommand(Command4NodeList command);
    
    
    /**
     * {@link org.unitarou.yukinoshita.view.GameFrameController}^[QbgƂ
     * R}hs܂B
     * @param command sR}hBĂяoiKł
     *         {@link Command4View#setCollectionEditor(CollectionEditor)}
     *         {@link Command4View#setEventBroker(EventBroker)}
     *         w肵ĂȂĂ悢B
     *         ʒmœK؂Ɋ蓖ĂƏȂB
     * @throws org.unitarou.lang.NullArgumentException commandnull̏ꍇ
     */
    void executeCommand(Command4View command);
}