/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.events;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.lang.Classes;
import org.unitarou.lang.Logging;
import org.unitarou.lang.Runtimes;
import org.unitarou.lang.Logging.Level;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.view.cmd.Command4View;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.monitor.OutlineMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/**
 * View甭CxgAꂼꃂfւ̑ɕRt邽߂̃nh[łB
 * eView͂̃CX^XA
 * Viewɑ΂鑀ŔCxgefire`\bhĂяoƂŒʒm܂B
 * 
 * ʒmׂViewԂƂ܂B
 * 
 * ElAҏWEҏW̏ԂɉView̃CxgModel̃CxĝЂt
 * ؂ւꍇ́A{@link org.unitarou.yukinoshita.events.HandlerSelector}
 * {@link org.unitarou.yukinoshita.events.StateHandler}g܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class EventBrokerImpl implements EventBroker {
	static private final Log log_s_ = LogFactory.getLog(EventBrokerImpl.class);
	
    /**
     * Viewp̃A_v^[NXłB
     */
    static private final Class[] viewAdapters_s_
    		= new Class[]{CollectionMonitor.class, 
            				GameMonitor.class, 
            				NodeListMonitor.class,
            				NodeMonitor.class, 
            				GameInfoNodeMonitor.class,
            				ContextMonitor.class,
            				ControllerStatusMonitor.class,
            				ProblemStatusMonitor.class,
            				OutlineMonitor.class,
            				LayoutMonitor.class,
            				CommandDriverMonitor.class};
    
    /**
     * Controllerp̃A_v^[NXłB
     */
    static private final Class[] ctrlAdapters_s_
    		= new Class[]{ActionListener.class};
    
    /**
     * ^[Class:listener, Set[Object]]łB
     * listener̃CX^XłObject̏Wێ܂B
     */
    private final Map<Class<?>, Set<Object>> adapterMap_;
    /** */
    private final HandlerSelector handlerSelector_;
    
    /**
     * 
     */
    public EventBrokerImpl() {
        super();
        adapterMap_ = new HashMap<Class<?>, Set<Object>>();
        handlerSelector_ = new HandlerSelector();
        handlerSelector_.setEventBroker(this);
    }
    
    public void dispose() {
    	for (Set<Object> set : adapterMap_.values()) {
    		set.clear();
    	}
        adapterMap_.clear();
        handlerSelector_.clear();
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.ModelEventHandler#addView(org.unitarou.lang.Adaptable)
     */
    public void addView(Adaptable view) {
        ArgumentChecker.throwIfNull(view);
        
        for (int i = 0; i < viewAdapters_s_.length; ++i) {
            addAdapter(view, viewAdapters_s_[i]);
        }
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.EventBroker#removeView(org.unitarou.lang.Adaptable)
     */
    public void removeView(Adaptable view) {
        ArgumentChecker.throwIfNull(view);

        for (int i = 0; i < viewAdapters_s_.length; ++i) {
            removeAdapter(view, viewAdapters_s_[i]);
        }
    }
    
    /**
     * View̎wɂModel̕ύX̒ʒm󂯂CX^Xo^܂B
     * {@link Adaptable#getAdapter(Class)}𗘗p̂ŁA
     * ctrl͎󂯎肽̌^w肷Kv܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    public void addController(Adaptable ctrl) {
        ArgumentChecker.throwIfNull(ctrl);

        for (int i = 0; i < ctrlAdapters_s_.length; ++i) {
            addAdapter(ctrl, ctrlAdapters_s_[i]);
        }
    }

    /**
     * o^ĂCX^X폜܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    public void removeController(Adaptable ctrl) {
        ArgumentChecker.throwIfNull(ctrl);

        for (int i = 0; i < ctrlAdapters_s_.length; ++i) {
            removeAdapter(ctrl, ctrlAdapters_s_[i]);
        }
    }

    /**
     * {@link #addView(Adaptable)}̎\bhłB
     * viewclazzA_v^[ƂĎĂꍇɁA
     * {@link #adapterMap_}ɂ̃A_v^[ǉ܂B
     * 
     * @log TRACE ǉA_v^[(A_v^[̎ނƎNX)
     */
    private void addAdapter(Adaptable adaptable, Class<?> clazz) {
        Object obj = adaptable.getAdapter(clazz);
        if (obj == null) {
            return;
        }
        if (!clazz.isInstance(obj)) {
            throw new IllegalArgumentException("Bad adapter: adaptable:" + adaptable  //$NON-NLS-1$
                    	+ " class:" + clazz +", but obj:" + obj);   //$NON-NLS-1$//$NON-NLS-2$
        }
        Set<Object> set = adapterMap_.get(clazz);
        if (set == null) {
            set = new HashSet<Object>();
            adapterMap_.put(clazz, set);
        }
        set.add(obj);
        
        if (log_s_.isTraceEnabled()) {
        	log_s_.trace("[ADD ADAPTER] " + Classes.simpleName(adaptable.getClass())  //$NON-NLS-1$
        			+ " has " + Classes.simpleName(clazz) + "\'s adapter: " + obj);  //$NON-NLS-1$//$NON-NLS-2$
        }
    }
    
    /**
     * 
     * @log TRACE 폜A_v^[(A_v^[̎ނƎNX)
     */
    private void removeAdapter(Adaptable adaptable, Class<?> clazz) {
        Object obj = adaptable.getAdapter(clazz);
        if (obj == null) {
            return;
        }
        if (!clazz.isInstance(obj)) {
            throw new IllegalArgumentException("Bad adapter: adaptable:" + adaptable  //$NON-NLS-1$
                    	+ " class:" + clazz +", but obj:" + obj);   //$NON-NLS-1$//$NON-NLS-2$
        }
        Set<Object> set = adapterMap_.get(clazz);
        if (set != null) {
            set.remove(obj);
        }
        if (log_s_.isTraceEnabled()) {
        	log_s_.trace("[DEL ADAPTER] " + Classes.simpleName(adaptable.getClass())  //$NON-NLS-1$
        			+ " has " + Classes.simpleName(clazz) + "\'s adapter: " + obj);  //$NON-NLS-1$//$NON-NLS-2$
        }
    }
    
    
    /**
     * @see org.unitarou.yukinoshita.events.EventBroker#getListeners(java.lang.Class)
     * 
     * @log WARN o^̃Xi[Ɏw肳ĂꍇB
     * @log TRACE Ԃ郊Xi[̃NXƁAXi[Ƃēo^ĂIuWFNgB
     */
	@SuppressWarnings("unchecked") //$NON-NLS-1$
	public <T> Set<T> getListeners(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);

        Set<Object> set = adapterMap_.get(clazz);
        if (set == null) {
            set = new HashSet<Object>();
            log_s_.warn("Unused or unregistered listener (May be BUG):" + clazz); //$NON-NLS-1$
        }
        
        Set<T> ret = new HashSet<T>(set.size());
        for (Object object : set) {
        	ret.add((T)object);
        }

        if (log_s_.isTraceEnabled()) {
        	log_s_.trace("[CALL LISTENER] " + clazz.getName() + " is called. " //$NON-NLS-1$//$NON-NLS-2$
        				+ "Listener size is " + ret.size());    //$NON-NLS-1$
        }
        return ret;
    }


    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.EventBroker#register(org.unitarou.sgf.type.GameType, boolean, org.unitarou.yukinoshita.events.StateHandler)
     */
    public void register(GameType gameType, boolean isEditMode, StateHandler stateHandler) {
        handlerSelector_.put(gameType, isEditMode, stateHandler);
        stateHandler.setEventBroker(this);

        if (log_s_.isTraceEnabled()) {
        	log_s_.trace("[REGISTER] " + gameType + "(Edit mode:"+ isEditMode //$NON-NLS-1$//$NON-NLS-2$
        				+ "), state handler: " + stateHandler);    //$NON-NLS-1$
        }
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.EventBroker#connect(org.unitarou.sgf.type.GameType, boolean)
     */
    public void connect(GameType gameType, boolean isEditMode) {
        handlerSelector_.connect(gameType, isEditMode);

        if (log_s_.isTraceEnabled()) {
        	log_s_.trace("[CONNECT] " + gameType + "/Edit mode:"+ isEditMode); //$NON-NLS-1$//$NON-NLS-2$
        }
    }
    
    public void disconnect() {
        handlerSelector_.disconnect();
        if (log_s_.isTraceEnabled()) {
        	log_s_.trace("[DISCONNECT] "); //$NON-NLS-1$
        }
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.EventBroker#getCurrentStateHander()
     */
    public StateHandler getCurrentStateHander() {
        return handlerSelector_.getCurrent();
    }

    
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.events.EventBroker#fireExecuteCommand(org.unitarou.yukinoshita.model.cmd.Command4NodeList)
	 */
	public void executeCommand(Command4NodeList command) {
        ArgumentChecker.throwIfNull(command);

        if (log_s_.isTraceEnabled()) {
        	log_s_.trace("[START COMMAND] " + command + " " + Runtimes.formatStackTrace(4)); //$NON-NLS-1$ //$NON-NLS-2$
        }
        
        for (ActionListener listener : getListeners(ActionListener.class)) {
        	listener.executeCommand(command);
        }

        if (log_s_.isTraceEnabled()) {
        	log_s_.trace("[END COMMAND] " + command); //$NON-NLS-1$//$NON-NLS-2$
        }
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.events.EventBroker#executeCommand(org.unitarou.yukinoshita.view.cmd.Command4View)
	 */
	@Logging(level = Level.TRACE, contents = "sꂽR}ĥ̖4iO܂ł̌Ăяo") //$NON-NLS-1$
	public void executeCommand(Command4View command) {
        ArgumentChecker.throwIfNull(command);
        if (log_s_.isTraceEnabled()) {
        	log_s_.trace("[START COMMAND] " + command + " " + Runtimes.formatStackTrace(4)); //$NON-NLS-1$ //$NON-NLS-2$
        }

        for (ActionListener listener : getListeners(ActionListener.class)) {
        	listener.executeCommand(command);
        }

        if (log_s_.isTraceEnabled()) {
        	log_s_.trace("[END COMMAND] " + command); //$NON-NLS-1$//$NON-NLS-2$
        }
	}
}
