/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.events;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.unitarou.yukinoshita.events.StateHandler}
 * ԂɉĎgƂɗpCxgnh[̃ZN^[łB
 * 
 * {@link #connect(GameType, boolean)}ɂ
 * {@link #put(GameType, boolean, SelectableViewEventHandler)}œo^ꂽ
 * Cxgnh[؂ւ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
class HandlerSelector {
    static private final Log log_s_ = LogFactory.getLog(HandlerSelector.class);
    /**
     * ^[String:key, {@link StateHandler}]
     */
    private final Map<String, StateHandler> handlerMap_;
    
    private StateHandler stateHandler_;
    /**
     * 
     */
    public HandlerSelector() {
        super();
        handlerMap_ = new TreeMap<String, StateHandler>();
        stateHandler_ = null;
    }

    public void put(GameType gameType, boolean isEditMode, StateHandler eventHandler) {
        handlerMap_.put(makeKey(gameType, isEditMode), eventHandler);
    }
    
    public void connect(GameType gameType, boolean isEditMode) {
        disconnect();
        String key = makeKey(gameType, isEditMode);
        stateHandler_ = handlerMap_.get(key);
        if (stateHandler_ == null) {
            log_s_.warn("Can't find StateHandler. key=" +  key); //$NON-NLS-1$
            return;
        }
        stateHandler_.connect();
    }
    
    public void disconnect() {
        if (stateHandler_ != null) {
            stateHandler_.disconnect();
            stateHandler_ = null;
        }
    }
    
    /**
     * {@link #handlerMap_}p̃L[쐬܂B
     * ł {@link GameType#getString()} + isEditMode̕łB 
     */
    private String makeKey(GameType gameType, boolean isEditMode) {
        return gameType.getString() + isEditMode;
    }

    public void setEventBroker(EventBroker broker) {
        ArgumentChecker.throwIfNull(broker);

        for (Iterator ip = handlerMap_.values().iterator(); ip.hasNext(); ) {
            StateHandler igoBoardEventHandler = (StateHandler)ip.next();
            igoBoardEventHandler.setEventBroker(broker);
        }
    }

    /**
     * ŕێĂ{@link StateHandler}SăNA[܂B
     */
    public void clear() {
        handlerMap_.clear();
        stateHandler_ = null;
    }

    /**
     * {@link #connect(GameType, boolean)}Ă
     * {@link StateHandler}Ԃ܂B
     * x{@link #put(GameType, boolean, StateHandler)}ĂȂꍇȂǂ
     * nullԂ邱Ƃ܂B
     */
    public StateHandler getCurrent() {
        return stateHandler_;
    }
}
