/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.events;

import java.util.Collections;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.view.cmd.Command4View;

/**
 * ȂCxgu[J[łB
 * ̃^C~OpɏĂ܂B
 * ȂAe\bhĂяoƁAfobNxŃOo͂܂B
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
final class NullEventBroker implements EventBroker {

    /**
     * ŃX^bNƃ[XpɐOłB 
     */
    static private class  NullEventBrokerException extends Exception {

		/**
		 * 
		 */
		private static final long serialVersionUID = 1841009054970030826L;

		public NullEventBrokerException() {
            super();
        }
    }
    
    
    /** ̃NXp̃K[łB*/
    static private final Log logger_s_ = LogFactory.getLog(NullEventBroker.class);

    /** ̃NXB̃CX^XłB*/
    static final EventBroker instance_s_ = new NullEventBroker(); 

    /**
     * 
     */
    private NullEventBroker() {
        super();
    }
    
    private void debugLog() {
        NullEventBrokerException exception = new NullEventBrokerException();
        exception.fillInStackTrace();
        logger_s_.debug("Call NullEventBroker's method, is it a Bug?", exception); //$NON-NLS-1$
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.ModelEventHandler#addView(org.unitarou.lang.Adaptable)
     */
    public void addView(Adaptable view) {
        debugLog();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.EventBroker#removeView(org.unitarou.lang.Adaptable)
     */
    public void removeView(Adaptable view) {
        // Ȃ
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.events.EventBroker#getListeners(java.lang.Class)
	 */
	public <T> Set<T> getListeners(Class<T> clazz) {
        debugLog();
		return Collections.emptySet();
	}

	/* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.ModelEventHandler#put(org.unitarou.sgf.type.GameType, boolean, org.unitarou.yukinoshita.events.SelectableViewEventHandler)
     */
    public void register(GameType gameType, boolean isEditMode, StateHandler eventHandler) {
        debugLog();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.ModelEventHandler#connect(org.unitarou.sgf.type.GameType, boolean)
     */
    public void connect(GameType gameType, boolean isEditMode) {
        debugLog();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.ModelEventHandler#disconnect()
     */
    public void disconnect() {
        debugLog();
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.EventBroker#getCurrentStateHander()
     */
    public StateHandler getCurrentStateHander() {
        debugLog();
        return null;
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.events.EventBroker#fireExecuteCommand(org.unitarou.yukinoshita.model.cmd.Command4NodeList)
	 */
	public void executeCommand(Command4NodeList command) {
        debugLog();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.events.EventBroker#executeCommand(org.unitarou.yukinoshita.view.cmd.Command4View)
	 */
	public void executeCommand(Command4View command) {
        debugLog();
	}
}
