/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.events;

import org.unitarou.util.Adaptable;
import org.unitarou.util.Adaptables;

/**
 * eq֌WCX^XQɑ΂āAeq̏ԂőSĂ̗vf
 * Ăяo悤ɓCxgnhłB<br>
 * ̓Iɂ͊epNX{@link #getAdaptables()}A
 * MۗL{@link org.unitarou.util.Adaptable}CX^XԂƂŁA
 * ̑SĂɑ΂{@link org.unitarou.util.Adaptable#getAdapter(Class)}
 * YCxgĂяo܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public abstract class TieredModelEventNotifier implements ModelEventNotifier {


    public TieredModelEventNotifier() {
        super();
    }
    
    
    /**
     * TuNX{@link #getAdaptables()}邱ƂŁA
     * ۗLCX^XSĂɑ΂Ẵ\bhĂяôNX̖ړIȂ̂ŁA
     * ̃\bhI[o[ChꍇAKeNX̃\bhĂяoĂB
     * 
     * Iɂ{@link #getAdaptables()}ŕԂA
     * {@link ModelEventNotifier}̃A_v^[CX^Xɑ΂
     * {@link ModelEventNotifier#setEventBroker(EventBroker)}ĂяoĂ܂B
     * 
     * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
     */
    public void setEventBroker(EventBroker eventBroker) {
        Object[] objs = Adaptables.getAdapters(
				ModelEventNotifier.class, getAdaptables());
        for (int i = 0; i < objs.length; ++i) {
            ((ModelEventNotifier)objs[i]).setEventBroker(eventBroker);
        }
    }
    
    /**
     * NXۗLAdaptableȃCX^XԂ܂B
     * ߂lƂċ̔zvf̈ꕔnullł邱Ƃ͋܂A
     * null̂̂ԂƂ͋܂B
     */
    abstract protected Adaptable[] getAdaptables();
}
