/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.CollectionEvent;
import org.unitarou.sgf.CollectionListener;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.unitarou.sgf.Collection}ҏW邽߂
 * bvGfB^[NXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class CollectionEditor {
	static private final Log logger_s_ = LogFactory.getLog(CollectionEditor.class);
    
	/** bvĂCollectionCX^XłB*/
	private final Collection collection_;
	
	/** bvĂ{@link #collection_}ւ̃Xi[łB */
	private final CollectionListener listener_;
	
	/**
	 * {@link RootGameTree}ɂꂼΉRg[[ێ܂B
	 * Rg[[{@link #initializeGame(Integer)}Œx܂B
	 */
	private final Map<Integer, GameMediator> gameMap_;

	/** ݃ANeBuɂȂĂQ[CollectionłIndexłB*/
	private int activeGameIndex_;
	
	/**
     * @throws org.unitarou.lang.NullArgumentException collectionnull̏ꍇB
     */
	public CollectionEditor(Collection collection) {
		this(collection, false);
	}
	
	/**
     * @throws org.unitarou.lang.NullArgumentException collectionnull̏ꍇB
     */
    public CollectionEditor(Collection collection, boolean setChangedFlag) {
        super();
        ArgumentChecker.throwIfNull(collection);
        collection_ = collection;
        listener_ = new CollectionListenerImpl();
        collection.addListener(listener_);
        gameMap_ = new HashMap<Integer, GameMediator>(collection_.size());
		activeGameIndex_ = 0;
		
		if (setChangedFlag) { // ŏҏWς݈ɂ鎞̂݁ASĂǂݏoB
			for (int i = 0; i < collection_.size(); ++i) {
				initializeGame(i, true);
			}
		}
    }

    /**
     * 
     */
    public void dispose() {
	    gameMap_.clear();
	    collection_.removeListener(listener_);
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#finalize()
	 */
	@Override
	protected void finalize() throws Throwable {
	    try {
			if (!gameMap_.isEmpty()) {
				logger_s_.warn(this + " is not disposed."); //$NON-NLS-1$
				dispose();
			}
	    } finally {
			super.finalize();
	    }
	}

    /**
     * gameIndexŎw肵Q[ANeBuɂ܂B
     *  
     * @param gameIndex ANeBuɂQ[̃CfbNX(0IW)
     * @throws IllegalArgumentException gameIndexRNV͈̔͂𒴂ꍇ
     */
    public void setActiveGame(int gameIndex) {
        if ((gameIndex < 0) || (collection_.size() <= gameIndex)) {
            throw new IllegalArgumentException(
                    "Parameter gameIndex is out of bounds. Game size is " + collection_.size() //$NON-NLS-1$
                    + ". Parameter gameIndex is " + gameIndex); //$NON-NLS-1$
        }
        activeGameIndex_ = gameIndex;
    }
    
    
    /**
     * bvĂ{@link Collection}Ԃ܂B
     * WȂǂ͓œWJ邽߁ARXgN^œn
     * CX^XƂ͈قȂCX^XԂƂ܂B
     */
    public Collection getCollection() {
        return collection_;
    }


    /**
     * ݃ANeBu(I)ĂQ[̃CfbNX(0IW)Ԃ܂B
     * @return 0IW̃CfbNX
     */
    public int getActiveGameIndex() {
        return activeGameIndex_;
    }
    
    /**
     * ݃ANeBu(IĂ){@link GameMediator}Ԃ܂B
     * xȂĂÃ\bȟĂяoɂȂ
     * {@link GameMediator}܂B
     * <code>null</code>͕Ԃ܂B
     */
    public GameMediator getActiveGame() {
    	return get(activeGameIndex_);
    }

    /**
     * indexɊY{@link GameMediator}܂B
     */
    private GameMediator initializeGame(int index, boolean setChangedFlag) {
        RootGameTree rootGameTree = collection_.get(index);
        GameMediator ret = new GameMediator(rootGameTree, setChangedFlag);
        gameMap_.put(new Integer(index), ret);
        return ret;
    }
    
    
    /**
     * ǂ̃Q[ҏWĂ邩zԂ܂B<br>
     * ߂l͒{@link Collection#size()}Ŋevftruȅꍇ
     * RootGameTreen܂Q[ҏWĂ邱Ƃ܂B
     */
    public boolean[] getChangedFlags() {
        boolean[] ret = new boolean[collection_.size()];
        for (int i = 0; i < ret.length; ++i) {
            GameMediator gm = gameMap_.get(new Integer(i));
            ret[i] = (gm != null) && gm.isChanged();
        }
        return ret;
    }
    
    /**
     * ҏWtONA[܂B
     * t@CƂĕۑꂽɌĂяo܂B
     */
    public void clearChangedFlags() {
    	for (GameMediator mediator : gameMap_.values()) {
    		mediator.clearChanged();
    	}
    }

    /**
     * GameMediatoȓԂ܂B
     * <code>getCollection().size()</code>ƓłB
     * @return GameMediatoȓ
     */
	public int size() {
		return collection_.size();
	}
	
	/**
	 * rgtCollectionɑgݍł̃Rg[ł
	 * {@link GameMediator}Ԃ܂B
	 * @param rgt
	 * @return
	 */
	public GameMediator createGame(RootGameTree rgt) {
		ArgumentChecker.throwIfNull(rgt);
		collection_.addLast(rgt);
		GameMediator gm =  initializeGame(collection_.size() - 1, true);
		return gm;
	}
	
	/**
	 * CollectionDrill`̏ꍇtrueԂ܂B
	 * @return
	 */
	public boolean isDrill() {
		return get(0).getGameType().equals(GameType.DRILL);
	}
	
	/**
	 * indexŎw肳ꂽGameMediatorKvł΍쐬ĕԂ܂B
	 * @param index
	 * @return
	 */
	private GameMediator get(int index) {
		if ((index < 0) || (collection_.size() <= index)) {
			throw new IndexOutOfBoundsException("Bad index:" + index); //$NON-NLS-1$
		}
        GameMediator ret = gameMap_.get(new Integer(index));
        if (ret == null) {
        	ret = initializeGame(index, false);
        }
        return ret;	
    }

	
	/**
	 * indexŎw肵{@link GameMediator}ƂɑΉ{@link Collection}폜܂B
	 * @param index
	 */
	public void remove(int index) {
		if ((index < 0) || (collection_.size() <= index)) {
			throw new IndexOutOfBoundsException("Bad index:" + index); //$NON-NLS-1$
		}
		collection_.remove(collection_.get(index));
	}

	/**
	 * ̃NXێ{@link Collection}p̃Xi[łB
	 */
	private class CollectionListenerImpl implements CollectionListener {

		/* (non-Javadoc)
		 * @see org.unitarou.sgf.CollectionListener#rootGameTreeRemoved(org.unitarou.sgf.CollectionEvent)
		 */
		public void rootGameTreeRemoved(CollectionEvent event) {
			RootGameTree target = event.getRootGameTree();
			for (Map.Entry<Integer, GameMediator> entry : gameMap_.entrySet()) {
				if (entry.getValue().getRootGameTree().equals(target)) {
					gameMap_.remove(entry.getKey());
					if (activeGameIndex_ == collection_.size()) {
						activeGameIndex_ = collection_.size() - 1;
					}
					return;
				}
			}
		}
	}
}
