/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfArgumentChecker;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.board.MarkupIgoBoard;

/**
 * rootgametreeꑱ̕ҏW\Ȓ胊Xg
 * iω}͂̂̈Ij\NXłB<br>
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 * @see org.unitarou.yukinoshita.model.NodeEntity
 */
public final class EditableNodeList implements NodeList {
	static private final Log log_s_ = LogFactory.getLog(EditableNodeList.class);

	/**
	 * RXgN^Ŏw肳邱̃Xg̃[głB
	 */
	private final RootGameTree root_;
	
	/**
	 * {@link #rollback()}ɂĕύXm肳A
	 * OQƂ钅胊XgłB 
	 */
	private final ArrayList<NodeEntity> entityList_;

	/**
	 * {@link #igoBoard_}Ή{@link #entityList_}
	 * 擪̃CfbNXłB
	 */
	private int boardIndex_;
	
	
	/**
	 * Xg̎ۂɃ[Uɕ\Ăǖʂ{@link #entityList_}̃CfbNXłB
	 * {@link #boardIndex_}Ƃ͈قȂ邱Ƃ܂B
	 */
	private int positionIndex_;
	
	/**
	 * w肵ꏊł̌Ղ̏Ԃێ܂B
	 * {@link NodeEntity#getIgoBoard()}̒lێĂ܂B
	 */
	private MarkupIgoBoard igoBoard_;
	

	
	/**
	 * 
	 * @param root
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public EditableNodeList(RootGameTree root) {
		super();
		ArgumentChecker.throwIfNull(root);
		root_ = root;
		igoBoard_ = new MarkupIgoBoard(root_.getSize());
		entityList_ = new ArrayList<NodeEntity>(
				root_.getGameType().equals(GameType.GAME) 
						? 300  //Ȃ璷300
						: 20); //lȂ璷20
		boardIndex_ = -1;
		positionIndex_ = -1;
		addLast(root_);
	}
	
	/**
	 * ̃XǧՂ̃TCYԂ܂B
	 */
	public SgfSize getSize() {
		return root_.getSize();
	}
	
	public RootGameTree getRoot() {
		return root_;
	}
	
	/**
	 * nodeEntitŷ̂XVꂽƂɌĂяo܂B
	 *  
	 * @param nodeEntity
	 * @throws IllegalArgumentException nodeEnitỹXgɊ܂܂ĂȂꍇB
	 */
	void update(NodeEntity nodeEntity) {
		ArgumentChecker.throwIfNull(nodeEntity);
		int index = entityList_.indexOf(nodeEntity);
		if (index == -1) {
			throw new IllegalArgumentException(
					"nodeEntity " + nodeEntity  //$NON-NLS-1$
					+ " is not found in entityList_"); //$NON-NLS-1$
		}
		
		nodeEntity.updateVariationIndex();
		//
		// PɈ̈OnodeEntityɌՂ߂
		// ɈnodeEntityՂoƂ玩I
		// @XV悤ɂȂB
		if (index == 0) {
			igoBoard_ = new MarkupIgoBoard(igoBoard_.size());
			nodeEntity.forwardUpdate(null, igoBoard_);
			boardIndex_  = -1;
		} else {
			updateIgoBoard(entityList_.get(index - 1));
		}
		
	}
	
	/**
	 * {@link #igoBoard_}̒gindex̒lɐݒ肵܂B 
	 * @param index
	 * @throws IllegalArgumentException nodeEnitỹXgɊ܂܂ĂȂꍇB
	 */
	MarkupIgoBoard updateIgoBoard(NodeEntity nodeEntity) {
		ArgumentChecker.throwIfNull(nodeEntity);

		int index = entityList_.indexOf(nodeEntity);
		if (index == -1) {
			throw new IllegalArgumentException(
					"nodeEntity " + nodeEntity  //$NON-NLS-1$
					+ " is not found in entityList_"); //$NON-NLS-1$
		}

		if (boardIndex_ < index) {
			forwardUpdateIgoBoard(index);
			log_s_.debug("forwardUpdateIgoBoard:" + index); //$NON-NLS-1$
		} else if (index < boardIndex_) {
			if (index != 0) {
				backwardUpdateIgoBoard(index - 1);
				log_s_.debug("backwardUpdateIgoBoard:" + (index - 1)); //$NON-NLS-1$
				forwardUpdateIgoBoard(index);
				log_s_.debug("forwardUpdateIgoBoard:" + index); //$NON-NLS-1$
			} else {
				backwardUpdateIgoBoard(index);
				log_s_.debug("backwardUpdateIgoBoard:" + index); //$NON-NLS-1$
			}
		}
		return igoBoard_;
	}
	
	/**
	 * ݂{@link #boardIndex_}Oɂindex܂
	 * {@link NodeEntity#forwardUpdate(NodeEntity, MarkupIgoBoard)}ĂяoA
	 * index{@link #boardIndex_}̒lƂA
	 * {@link #igoBoard_}{@link #boardIndex_}̎lɐݒ肵܂B
	 * 
	 * @param index
	 */
	private void forwardUpdateIgoBoard(int index) {
		for (int i = boardIndex_ + 1; i <= index; ++i) {
			NodeEntity previous = (i == 0) ? null : entityList_.get(i - 1); 
			entityList_.get(i).forwardUpdate(previous, igoBoard_);
		}
		boardIndex_ = index;
	}

	/**
	 * ݂{@link #boardIndex_}ɂindex܂
	 * {@link NodeEntity#backwardUpdate(MarkupIgoBoard)}ĂяoA
	 * index{@link #boardIndex_}̒lƂA
	 * {@link #igoBoard_}{@link #boardIndex_}̎lɐݒ肵܂B
	 * 
	 * @param index
	 */
	private void backwardUpdateIgoBoard(int index) {
		//擪w肳ꂽꍇ͂Oɂ͖߂Ȃ̂
		//ՂNA[ĂB
		if (index == 0) {
			clearIgoBoard();
			return;
		}
		for (int i = boardIndex_; i >= index + 1; --i) {
			entityList_.get(i).backwardUpdate(igoBoard_);
		}
		boardIndex_ = index;
	}
	
	/**
	 * Ղ(rootm[hŎw肳ꂽTCY)ɖ߂܂B
	 */
	private void clearIgoBoard() {
		igoBoard_ = new MarkupIgoBoard(root_.getSize());
		boardIndex_ = -1;
	}

	
	/**
	 * 
	 * @param rollBackTo 폜ω}̑IɔigoBoard̊߂ʒuA
	 *                       {@link #boardIndex_}炱̒l܂ŌՂ߂B
	 */
	private void rollback(int rollBackTo) {
		// NodeEntitypOɔpȌꏊ܂igoBoard߂Ă
		if (!entityList_.isEmpty()) {
			updateIgoBoard(entityList_.get(rollBackTo));
		}
	}
	
	
	/**
	 * Xg̍Ŋtree{@link NodeEntity}ǉ܂B<br>
	 * ͑Sčŏ̎}I܂B 
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void addLast(GameTree gameTree) {
	    ArgumentChecker.throwIfNull(gameTree);
	    addLastImpl(gameTree);
	}
	
	/**
	 * gameTreeċAIɃm[hǉĂ܂B
	 * @param gameTree
	 */
	private void addLastImpl(GameTree gameTree) {
	    for (Node node : gameTree.getSequence()) {
			entityList_.add(new NodeEntity(
					node, 
					gameTree, 
					this, 
					entityList_.isEmpty() ? null : getLast()));
	    }

	    if (gameTree.getChildrenSize() != 0) {
			addLastImpl(gameTree.getChild(0));
	    }
		SgfArgumentChecker.throwIfInvalid(root_);
	}

	/**
	 * nodeEntities̔zXg̍Ŋɒǉ܂B
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void addLast(NodeEntity[] nodeEntities) {
		ArgumentChecker.throwIfNull((Object)nodeEntities);
		for (NodeEntity nodeEntity : nodeEntities) {
			nodeEntity.updateVariationIndex();
			nodeEntity.setPrevious(entityList_.isEmpty() ? null : getLast());
			entityList_.add(nodeEntity);
		}
	}

	/** 
	 * nodeEntityXg̍Ŋɒǉ܂B
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void addLast(NodeEntity nodeEntity) {
		ArgumentChecker.throwIfNull(nodeEntity);
		nodeEntity.updateVariationIndex();
		nodeEntity.setPrevious(entityList_.isEmpty() ? null : getLast());
		entityList_.add(nodeEntity);
	}
	
	/**
	 * nodenodeEntityƂăXg̍Ōɒǉ܂B
	 * @param node ǉm[h
	 * @param gameTree node̒ڂ̐e
	 * @return ǉꂽGeBeB
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public NodeEntity addLast(Node node, GameTree gameTree) {
		ArgumentChecker.throwIfNull(node, gameTree);
		NodeEntity entity = new NodeEntity(
					node, 
					gameTree,
					this, 
					entityList_.isEmpty() ? null : getLast());
		entityList_.add(entity);
		return entity;
	}
	
	/** 
	 * insertPoint̒target}܂B
	 * insertPoint<code>null</code>̏ꍇ́A擪ɒǉ܂B
	 * @return ǉGeBeB
	 * @throws IllegalArgumentException insertPointc[ɑ݂ȂꍇB
	 */
	public NodeEntity insert(Node node, GameTree gameTree, NodeEntity insertPoint) {
		SgfArgumentChecker.throwIfNotAChild(node, gameTree);
		
		int index = entityList_.indexOf(insertPoint);
		if (index == -1) {
			throw new IllegalArgumentException();
		}
		NodeEntity previous = null;
		if (index == 0) {
			log_s_.warn("Can't rollback because of zero index"); //$NON-NLS-1$
		} else {
			rollback(index - 1);
			previous = get(index - 1);
		}
		NodeEntity entity = new NodeEntity(node, gameTree, this, previous);
		entity.setPrevious(entityList_.size() <= index ? null : entityList_.get(index - 1));
		entityList_.add(index, entity);
		return entity;
	}

	/** 
	 * targetXg폜܂B폜ɐtrueԂ܂B<br> 
	 * 폜ꂽNodeEntitył{@link NodeEntity#getPrevious()}
	 * <code>null</code>ɐݒ肳܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public boolean remove(NodeEntity target) {
		ArgumentChecker.throwIfNull(target);
		int pos = entityList_.indexOf(target);
		if (0 < pos) {
			NodeEntity removed = entityList_.remove(pos);
			removed.setPrevious(null);
			rollback(pos);
			return true;
		}
		return false;
	}

	/** 
	 * Xg̍Ŋ̗vf폜ĕԂ܂B
	 * 폜ꂽNodeEntitył{@link NodeEntity#getPrevious()}
	 * <code>null</code>ɐݒ肳܂B
	 */
	public NodeEntity removeLast() {
		if (entityList_.isEmpty()) {
			throw new NoSuchElementException("entityList_ is empty"); //$NON-NLS-1$
		}
		if (entityList_.size() == 1) {
			// Ō̈Ȃ̂ŏԂɖ߂B
			clearIgoBoard();
		} else {
			rollback(entityList_.size() - 2);
		}
		NodeEntity ret = entityList_.remove(entityList_.size() - 1);
		ret.setPrevious(null);
		return ret;
	}
	
	
	/**
	 * Xg̎ۂɃ[Uɕ\ĂǖʂԂ܂B<br>
	 * @return
	 */
	public NodeEntity getPosition() {
		return get(positionIndex_);
	}
	
	/**
	 * ǖʂnewIndexŎꏊɈړ܂B
	 * @param newIndex
	 * @throws IndexOutOfBoundsException {@link #entityList_}͈̔͂𒴂ꍇB
	 */
	public void setPositionIndex(int newIndex) {
		if ((newIndex < 0) || (entityList_.size() <= newIndex)) {
			throw new IndexOutOfBoundsException(
					newIndex + " is out of range (size is " + entityList_.size() + ").");		 //$NON-NLS-1$ //$NON-NLS-2$
		}
		positionIndex_ = newIndex;
	}
	
	/**
	 * ǖʂ̃Xgł̃CfbNXԂ܂B
	 * @return
	 */
	public int getPositionIndex() {
		return positionIndex_;
	}
	
	
	
    /** indexŎw肳ꂽXg̗vfԂ܂B*/
	public NodeEntity get(int index) {
		return entityList_.get(index);
	}

	/**
	 * Xg̍Ŋ̗vfԂ܂B
	 * @throws IllegalStateException Xgɗvfꍇ
	 */
	public NodeEntity getLast() {
	    if (entityList_.isEmpty()) {
	        throw new IllegalStateException("Current list is empty."); //$NON-NLS-1$
	    }
		return entityList_.get(entityList_.size() - 1);
	}

	/** 
	 * Xg̃TCYԂ܂B
	 */
	public int size() {
		return entityList_.size();
	}

	/** 
	 * targetXgɊ܂܂ĂtrueԂ܂B
	 */
	public boolean contains(NodeEntity target) {
		return entityList_.contains(target);
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.MovesMediator#getLastNodeView()
	 */
	public NodeView getLastNodeView() { 
		return getLast().getNodeView();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.MovesMediator#getNodeView(int)
	 */
	public NodeView getNodeView(int index) {
		return get(index).getNodeView();
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.NodeList#getCurrentNodeView()
	 */
	public NodeView getCurrentNodeView() {
		return getPosition().getNodeView();
	}


    /**
     * [gm[h̕ύXȂǂɂSGeBeBXVꍇɌĂяo܂B<br>
     * ł{@link SgfId#SIZE}XVꂽ̂݁A
     * ŜtbV܂B
     * @param updateType
     * @return trueŃtbVsꂽB
     */
    public boolean refresh(Set<SgfId> updateIds) {
    	ArgumentChecker.throwIfNull(updateIds);
    	if (updateIds.contains(SgfId.SIZE)) {
    		igoBoard_ = new MarkupIgoBoard(root_.getSize());
    		entityList_.clear();		
    		boardIndex_ = -1;
    		positionIndex_ = -1;
    		addLast(root_);
    		return true;
    
    	// ŕω}̑IXV̂c
    	} else if (updateIds.contains(SgfId.STYLE)) {
    		if (root_.getStyle().isChildrenStyle()) {
        		// ݂eq^̏ꍇ̑OZ^Ƃ݂ȂB
        		// 򂪈㗬ɂȂB
    			for (int i = 1; i < entityList_.size(); ++i) {
    				NodeEntity prev = entityList_.get(i - 1);
    				NodeEntity now = entityList_.get(i);
    				prev.setSelectedVariationIndex(now.getUnmodifiedSelectVariationIndex());
    			}
    			entityList_.get(entityList_.size() - 1).setSelectedVariationIndex(NodeEntity.NO_VARIATION);
    			
    		} else {
        		// ݂Z^̏ꍇ̑Oeq^Ƃ݂Ȃ
        		// 򂪈ɂ
    			for (int i = entityList_.size() - 1; 0 < i; --i) {
    				NodeEntity prev = entityList_.get(i - 1);
    				NodeEntity now = entityList_.get(i);
    				now.setSelectedVariationIndex(prev.getUnmodifiedSelectVariationIndex());
    			}
    			entityList_.get(0).setSelectedVariationIndex(NodeEntity.NO_VARIATION);
    		}
    		return true;
    	}
    	return false;
	}
    
}
