/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.lang.Logging;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.lang.Logging.Level;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.unitarou.sgf.Node}̐ec[ƁA
 * ec[ɂƂÂGetter\bhCX^XłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class NodeTree {
	static private final Log log_s_ = LogFactory.getLog(NodeTree.class);

	/** [g̃`FbNpɍŏʂGameTreeێĂ܂B */
    private final RootGameTree rootGameTree_;
	
    /** tree_{SE GT{SE(node_) (GT)(GT)(GT)}(GT)}*/
    private final GameTree parentGameTree_;

    /** tree_{SE(node_) (GT)(GT(GT)}*/
    private final GameTree gameTree_;

    private final Node node_;
    
    /**
     * @throws NullArgumentException ̉ꂩnull̏ꍇ 
     * @throws AssertionError tree̍ŏʂGameTreeRootGameTreeȊȌꍇB
     */
    public NodeTree(Node node, GameTree tree) {
        super();
        ArgumentChecker.throwIfNull(node, tree);

        node_ = node;
        gameTree_ = tree;
        parentGameTree_ = gameTree_.getParent();
        GameTree root = Sgfs.getRoot(gameTree_);
		assert root instanceof RootGameTree 
				: "Root tree must be an instance of RootGameTree."; //$NON-NLS-1$
		rootGameTree_ = (RootGameTree)root;
    }
    
    
    /**
     * tree_{SE(node_) (GT)(GT(GT)}
     */
    public GameTree getGameTree() {
        return gameTree_;
    }
    
	/**
	 * tree_{SE GT{SE(node_) (GT)(GT)(GT)}(GT)}
	 */
    public GameTree getParentGameTree() {
        return parentGameTree_;
    }

	/**
	 * 
	 */
	public RootGameTree getRootGameTree() {
		return rootGameTree_;
	}

	/**
     * ω}childrenX^C(V[PX̍Ōŕω}ʒm)
     * \ƂtrueԂ܂B
     * ܂siblingsX^C(V[PX̍ŏŕω}ʒm)
     * \ƂfalseԂ܂B
     */
    public boolean isChildrenStyle() {
        return rootGameTree_.getStyle().isChildrenStyle();
    }


    /**
     * @return
     */
    public SgfSize getSize() {
        return rootGameTree_.getSize();
    }

	/**
	 * ݂̃m[hV[PX̐擪łƂtrueԂ܂B
	 */
    public boolean isFirstNode() {
        return gameTree_.getSequence().getFirst() == node_;
    }

	/**
	 * ݂̃m[hV[PX̖łƂtrueԂ܂B
	 */
    public boolean isLastNode() {
    	Node node = gameTree_.getSequence().getLast();
        return (node == null) ? true : node == node_;
    }


    /**
     * Showing variations as childrenł́A
     * V[PX̖[łȂAω}Ƃ݂ȂȂB
     */
    private boolean hasChildVariation() {
	    return (rootGameTree_.getStyle().isChildrenStyle() && isLastNode());
    }


    /**
     * Showing variations as siblingsł́A
     * V[PX̐擪ŁAe̐̕oB
     */
    private boolean hasSiblingVariation() {
	    return (!rootGameTree_.getStyle().isChildrenStyle() 
	        	&& isFirstNode() && (parentGameTree_ != null)); 
    }


	/** 
	 * ̃m[hɑ݂ω}̐Ԃ܂B
	 * eq^ƌZ^`FbNāAK؂ȐlԂ܂B
	 * ω}݂Ȃꍇ0Ԃ܂B
	 */
    public int getVariationSize() {
	    return hasChildVariation() ? gameTree_.getChildrenSize() 
	            	: hasSiblingVariation() ? parentGameTree_.getChildrenSize() : 0;
    }


    /**
     * Children, Sibling̃^Cvɍ킹ĕԂ܂B
     * ǂ0Ԗڂ̗vf͖{łB
     * }ꍇ͗vf0̔zԂ܂Bnull͕Ԃ܂B
     */
    @Logging(level = Level.TRACE, contents = "ƂRoot̑Ή") //$NON-NLS-1$
	public GameTree[] getVariation() {
	    GameTree[] children;
	    if (hasChildVariation()) {
	        children = gameTree_.getChildren();
	    } else if (hasSiblingVariation()) {
	        children = parentGameTree_.getChildren(); 
	    } else {
	    	children = new GameTree[0];
	    }

	    // fobNR[h
	    // qc[Root𒲂ׂăOɏoĂB
	    if (log_s_.isTraceEnabled()) {
	    	for (GameTree child : children) { 
	    		GameTree root = Sgfs.getRoot(child);
	    		if (root instanceof RootGameTree) {
		    		log_s_.trace(child + "\'s Root is " + root); //$NON-NLS-1$
	    		} else {
	    			log_s_.trace(child + " does not have RootGameTree. Root is " + root); //$NON-NLS-1$
	    		}
	    	}
	    }
	    
        return children;
    }
}
