/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model;

import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.Application;
import org.unitarou.sgf.type.FileFormat;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.sgf.type.SgfNumber;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.Style;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.unitarou.sgf.RootGameTree}ҏWȂ悤ɃbvNXłB
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class RootView {

	private final RootGameTree rootGameTree_;
	/**
	 * 
	 */
	public RootView(RootGameTree rootGameTree) {
		super();
		ArgumentChecker.throwIfNull(rootGameTree);
		rootGameTree_ = rootGameTree;
	}
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.RootGameTree#getApplication()
	 */
	public Application getApplication() {
		return rootGameTree_.getApplication();
	}
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.RootGameTree#getCharset()
	 */
	public SgfCharset getSgfCharset() {
		return rootGameTree_.getSgfCharset();
	}
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.RootGameTree#getFileFormat()
	 */
	public FileFormat getFileFormat() {
		return rootGameTree_.getFileFormat();
	}
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.RootGameTree#getGameMode()
	 */
	public SgfNumber getGameMode() {
		return rootGameTree_.getGameMode();
	}
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.RootGameTree#getGameType()
	 */
	public GameType getGameType() {
		return rootGameTree_.getGameType();
	}
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.RootGameTree#getSize()
	 */
	public SgfSize getSize() {
		return rootGameTree_.getSize();
	}
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.RootGameTree#getStyle()
	 */
	public Style getStyle() {
		return rootGameTree_.getStyle();
	}
}
