/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.board;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.lang.ForStackTraceException;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFormatter;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.Stone;
import org.unitarou.util.ArgumentChecker;

/**
 * uՁv̂̂\NXłB<br>
 * L⃉xAƂvfɂĂ͂̃NXł͈܂B
 * ɒƔz΁EAQn}Eԍ\NXłB
 * <p>
 * Ńt@XJE^[𗘗pĂ̂ŁA
 * CX^Xjꍇ{@link dispose()}Ăт܂傤B
 * </p>
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class IgoBoard implements IgoBoardView {
	static private final Log log_s_ = LogFactory.getLog(IgoBoard.class);

	/**
	 * Ղ̃TCY܂B
	 */
	private SgfSize size_;
	
	/** ݔՂɒuĂ鍕΂Ӗ܂B*/
	private final Set<StoneGroup> blackGroups_;

	/** ݔՂɒuĂ锒΂Ӗ܂B*/
	private final Set<StoneGroup> whiteGroups_;
	
	/**
	 * ՂɒuĂS΂ێ܂B
	 * {@link #isEmpty(SgfPoint)}̍płB
	 */
	private final Map<SgfPoint, Stone> allStones_;
	
	/**
	 * ꂼ̃AQn}ێ܂B
	 * n}͑łꂽꏊێ܂
	 */
	private final List<Stone> captured_;
	
	/**
	 * {@link Log#isDebugEnabled()}̎
	 * \žĂяoێĂ܂B
	 * ȊÔƂ͏nullłB
	 */
	private ForStackTraceException stackTraceOfConstructor_;

	// \zn\bh
	/**
	 * 
	 */
	public IgoBoard(SgfSize size) {
		super();
		ArgumentChecker.throwIfNull(size);

		size_ = size;
		blackGroups_ = new HashSet<StoneGroup>(2);
		whiteGroups_ = new HashSet<StoneGroup>(2);
		allStones_ = new HashMap<SgfPoint, Stone>();
		captured_ = new ArrayList<Stone>(0);
		if (log_s_.isDebugEnabled()) {
		    stackTraceOfConstructor_ = new ForStackTraceException();
		    stackTraceOfConstructor_.fillInStackTrace();
		}
	}
	// ܂ō\zn\bh

	
	// jn\bh
	/** 
	 * ̃CX^XێĂ{@link StoneGroup}j܂B<br>
	 * jÃCX^X͎gp\łB
	 * ̓Iɂ{@link #blackGroups_}{@link #whiteGroups_}A{@link #allStones_}
	 * NA[܂B
	 */
	public void dispose() {
		allStones_.clear();
	}
	
	

	
	
	// ύXn\bh
	/**
	 * sgfColor̃AQn}pointsɒu܂B
	 * @param sgfColor
	 * @param points
	 */
	public void setCaptured(List<Stone> captured) {
		ArgumentChecker.throwIfNull(captured);
		captured_.clear();
		captured_.addAll(captured);
	}
	
	/**
	 * capturedStone폜܂B 
	 * @param color
	 * @param capturedStones
	 */
	public void removeCaptured(List<Stone> capturedStones) {
		ArgumentChecker.throwIfNull(capturedStones);
		
		if (!log_s_.isDebugEnabled()) {
			captured_.removeAll(capturedStones);
			return;
		}
		for (Stone stone : capturedStones) {
			if (!captured_.remove(stone)) {
				assert false;
			}
		}
	}

	/**
	 * Ղ̃TCYύX܂B
	 * ݕێĂ΂̏́iႦTCYłĂjNA[܂B
	 */
	public void setSize(SgfSize size) {
		ArgumentChecker.throwIfNull(size);
		
		if (size_.equals(size)) {
			return;
		}
		size_ = size;
	}
	
	/**
	 * ΂ł܂B֎~_̊mF͍s܂񂪁A΂̎グ͍s܂B
	 * ܂AȄꍇ͐΂グÂ܂܂̏ԁi_Ojŕu܂
	 * グ΂̔zi\[gς݁jԂ܂B
	 * VȎ΂̐AQn}܂B
	 * @deprecated
	 */
	@Deprecated
	public Stone[] moveStone(SgfColor color, SgfPoint point) {
		return moveStone(new Stone(color, point, null));
	}
	
	/**
	 * ΂ł܂B֎~_̊mF͍s܂񂪁A΂̎グ͍s܂B
	 * ܂AȄꍇ͐΂グÂ܂܂̏ԁi_Ojŕu܂
	 * グ΂̔zi\[gς݁jԂ܂B
	 * VȎ΂̐AQn}܂B
	 */
	public Stone[] moveStone(Stone stone) {
		ArgumentChecker.throwIfNull(stone);
		
		SgfPoint point = stone.getPoint();
		SgfColor color = stone.getColor();
		setStone(stone);
		if (point.condition() == SgfPointType.PASS) { //pX̏ꍇ͍폜Ȃ
			return Stone.EMPTY_ARRAY;
		}
		return removeDeadStone(color.opposite());
	}

	
	/**
	 * @param color
	 * @param point
	 * @deprecated
	 */
	@Deprecated
	public void setStone(SgfColor color, SgfPoint point) {
		setStone(new Stone(color, point, null));
	}

	/** 
	 * pointcolor̐΂u܂B
	 * ֎~_̊mFs܂񂵁A΂̎グs܂B
	 * pointpX̏ꍇ͉܂B
	 * 
	 * @throws NullArgumentException ̉ꂩ<code>null</code>̏ꍇ
	 * @throws IllegalArgumentException pointՂ̊Ȍꍇ
	 */
	public void setStone(Stone stone) {
		ArgumentChecker.throwIfNull(stone);
		SgfPoint point = stone.getPoint();
		SgfColor color = stone.getColor();
		ArgumentChecker.throwIfNull(point, color);

		if (point.condition() == SgfPointType.OUT) {
			throw new IllegalArgumentException("Bad point:" + point); //$NON-NLS-1$

		} else if (point.condition() == SgfPointType.PASS) { //pX̏ꍇ͉Ȃ
			return;
		}
		
		// point̋ߐړ_ŋ_TB
		Collection<SgfPoint> lifePoints = findLifePoints(point);
		
		// ΂u[StoneGroup]
		Collection<StoneGroup> target = getStoneGroups(color);
		if (!appendStone(target, point, lifePoints)) {
			StoneGroup newGroup = new StoneGroup(size_);
			newGroup.add(point, lifePoints);	
			target.add(newGroup);
		}
		
		/** {@link #allStones_}̍XV*/
		allStones_.put(point, stone);

		// _̍XV
		for (StoneGroup stoneGroup : getStoneGroups(color.opposite())) {
			stoneGroup.removeLifePoint(point);
		}
	}
	
	/**
	 * colorStoneGroup̏WA
	 * ̓Iɂ({@link #blackGroups_){@link #whiteGroups_}Ԃ܂B
	 * @param color
	 * @return
	 */
	private Set<StoneGroup> getStoneGroups(SgfColor color) {
		return (color == SgfColor.BLACK) ? blackGroups_ : whiteGroups_;
	}


	/** ǂ̃O[vɒǉłꍇtrueԂ܂B*/
	private boolean appendStone
			(Collection<StoneGroup> groups, 
			 SgfPoint point, 
			 Collection<SgfPoint> lifePoints) 
	{
		assert groups != null && point != null && lifePoints != null;
		
		// ^[StoneGroup]AǉΏۂƂȂ肤O[v(őS)
		ArrayList<StoneGroup> targetGroups 
			= new ArrayList<StoneGroup>(SgfPoint.MAX_NEIGHBORS);
		for (StoneGroup stoneGroup : groups) {
			if (stoneGroup.isLifePoint(point)) {
				targetGroups.add(stoneGroup);
			}
		}
		if (targetGroups.isEmpty()) {
			return false;
		}

		Iterator<StoneGroup> ipt = targetGroups.iterator();
		StoneGroup target = ipt.next();
		target.add(point, lifePoints);
		
		// ꍇ́Aŏ̃O[vɓB
		while(ipt.hasNext()) {
			StoneGroup src = ipt.next(); 
			target.add(src);
			groups.remove(src);			
		}
		return true;
	}
	
	/**
	 * pointɂ΂菜܂B
	 * pointɐ΂ꍇ͉܂B
	 * @return グꂽ΂̐FB݂Ȃꍇnull
	 */
	public SgfColor removeStone(SgfPoint point) {
		/** ΂グ̂{@link #allStones_}XV */
		allStones_.remove(point);
		
		// Gɍ肷
		
		for (Iterator<StoneGroup> ip = blackGroups_.iterator(); ip.hasNext(); ) {
		    StoneGroup group = ip.next();
		    if (!group.contains(point)) {
		        continue;
		    }
		    StoneGroup[] groups = group.remove(point);
		    
		    // ΐOɂȂꍇ
		    if (group.count() == 0) { 
		    	ip.remove();
		    }

			for (int i = 1; i < groups.length; ++i) {
			    blackGroups_.add(groups[i]);
			}
			// ΂̏ɂ銈_̔z
			Collection opposite = whiteGroups_;
			for (Iterator jp = opposite.iterator(); jp.hasNext();) {
				StoneGroup group2 = (StoneGroup)jp.next();
				group2.addLifePoint(point);
			}
			return SgfColor.BLACK;
		}

		for (Iterator<StoneGroup> ip = whiteGroups_.iterator(); ip.hasNext(); ) {
		    StoneGroup group = ip.next();
		    if (!group.contains(point)) {
		        continue;
		    }
		    StoneGroup[] groups = group.remove(point);
		    
		    // ΐOɂȂꍇ
		    if (group.count() == 0) { 
		    	ip.remove();
		    }
			for (int i = 1; i < groups.length; ++i) {
			    whiteGroups_.add(groups[i]);
			}
			// ΂̏ɂ銈_̔z
			Collection opposite = blackGroups_;
			for (Iterator jp = opposite.iterator(); jp.hasNext();) {
				StoneGroup group2 = (StoneGroup)jp.next();
				group2.addLifePoint(point);
			}
			return SgfColor.WHITE;
		}
		return null;
	}
	
	
	/** 
	 * color̎ΔsAłꍇ͎菜܂B
	 * VȎ΂̐AQn}܂B
	 * 
	 * ΂菜Ƃɂđ̃_܂B
	 * グ΂̔zi\[gς݁jԂ܂B
	 */
	private Stone[] removeDeadStone(SgfColor color) {
		// ΂̊mFƏ
		Collection<StoneGroup> target = getStoneGroups(color);
		Collection<StoneGroup> opposite = getStoneGroups(color.opposite());

		Set<SgfPoint> deadStones = new HashSet<SgfPoint>();
		for (Iterator<StoneGroup> ip = target.iterator(); ip.hasNext(); ) {
			StoneGroup group = ip.next();
			if (group.countLifePoint()==0) { //΂łꍇ
				ip.remove();
				deadStones.addAll(group.stones());
			}
		}
		
		// ΂̏ɂ銈_̔z
		for (StoneGroup stoneGroup : opposite) {
			for (SgfPoint sgfPoint : deadStones) {
				stoneGroup.addLifePoint(sgfPoint);
			}
		}
		
		Stone[] ret = new Stone[deadStones.size()];
		int index = 0;
		/** ΂グ̂{@link #allStones_}XV */
		for (SgfPoint sgfPoint : deadStones) {
			Stone stone = allStones_.get(sgfPoint);
			if (stone != null) {
				captured_.add(stone);
				ret[index] = allStones_.get(sgfPoint);
				allStones_.remove(sgfPoint);
			} else {
				assert false 
					: "Not found stone " + sgfPoint  //$NON-NLS-1$
						+ " in " + BasicFormatter.format(allStones_.keySet()); //$NON-NLS-1$
			}
			++index;
		}
		
		return ret;
	}
	// ܂ŕύXn\bh
	

	// Qƌn\bh
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.board.IgoBoardView#isForbiddenMove(org.unitarou.sgf.type.SgfPoint, org.unitarou.sgf.type.SgfColor, org.unitarou.sgf.type.SgfPoint, org.unitarou.sgf.util.Stone[])
	 */
	public boolean isForbiddenMove(
	        SgfPoint point, SgfColor color, SgfPoint lastMove, Stone[] lastCaptured){
		ArgumentChecker.throwIfNull(point, color, lastMove, lastCaptured);
		
		// łꏊɐ΂Β֎~_
		if (!isEmpty(point)) {
			return true;
		}
		
		// ̐΂ꍇ́AŨ_OɂȂĂǂA
		// RE̒̎Ԃ̏ꍇ͒֎~_
		Collection<StoneGroup> opposite = getStoneGroups(color.opposite());
		for (StoneGroup stoneGroup : opposite) {
			if (stoneGroup.countLifePoint() == 1 && stoneGroup.isLifePoint(point)) {
				return isKoViolation(stoneGroup, point, lastMove, lastCaptured);
			}
		}
		
		// ̐΂͎Ȃ̂ŁAE̊mF
		int lifePoint = findLifePoints(point).size();
		if (lifePoint != 0) { // ̐΂Ƀ_ΖȂ
			return false;
		}
		
		// ɂĈQ̐΂̃_OɂȂȂ璅֎~_
		Collection<StoneGroup> friend = getStoneGroups(color);
		for (StoneGroup stoneGroup : friend) {
			if (stoneGroup.isLifePoint(point)) { //̃O[vɂȂꍇ
				lifePoint += stoneGroup.countLifePoint() - 1; //̐Ύg_l߂̂łP
				if (lifePoint != 0) { //ł_̂ȂOK
					return false;
				}
			}
		}
		return (lifePoint == 0); 
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.board.IgoBoardView#diff(org.unitarou.yukinoshita.model.board.IgoBoard)
	 */
	public SortedMap<SgfPoint, SgfColor> diff(IgoBoard src) {
		ArgumentChecker.throwIfNull(src);

		if (!size_.equals(src.size_)) {
			throw new IllegalArgumentException("Bad size: " + size_ + "!=" + src.size_);  //$NON-NLS-1$//$NON-NLS-2$
		}
		
		SortedMap<SgfPoint, SgfColor> ret = new TreeMap<SgfPoint, SgfColor>();
		diff(SgfColor.BLACK, src.blackGroups_, blackGroups_, ret);
		diff(SgfColor.WHITE, src.whiteGroups_, whiteGroups_, ret);
		return ret;
	}
	
	/**
	 * srcGroupdesGroup̑S΂rāAdesGroupɂsrcGroupɖ΂ǉA
	 * desGroupɂȂsrcGroupɂ΂_ɒuēo^B
	 * srcGroups, desGroupš^[StoneGroup]A
	 * diffMap̌^[Point, Color]łB
	 */
	private void diff(SgfColor color, 
						Collection<StoneGroup> srcGroups, 
						Collection<StoneGroup> desGroups, 
						SortedMap<SgfPoint, SgfColor> diffMap) 
	{
		SortedSet<SgfPoint> srcStones = new TreeSet<SgfPoint>();
	    for (StoneGroup stoneGroup : srcGroups) {
			srcStones.addAll(stoneGroup.stones());
	    }
		
		//^[Point]
		SortedSet<SgfPoint> desStones = new TreeSet<SgfPoint>();
		for (StoneGroup stoneGroup : desGroups) {
			desStones.addAll(stoneGroup.stones());
		}
		
		// Q̏WׂĂĂꍇɂ͂̃Y΂_ɊҌB
		Iterator<SgfPoint> sip = srcStones.iterator();
		Iterator<SgfPoint> dip = desStones.iterator();
		while (sip.hasNext() || dip.hasNext()) {
			if (!sip.hasNext()) {
				while (dip.hasNext()) {
					diffMap.put(dip.next(), color);
				}
			} else if (!dip.hasNext()) {
				while (sip.hasNext()) {
					putNull(diffMap, sip.next());
				}
			} else {
				SgfPoint sp = sip.next();
				SgfPoint dp = dip.next();

				do {
					final int compared = sp.compareTo(dp);
					if (compared < 0) {
						putNull(diffMap, sp);
						if (!sip.hasNext()) { //SRCł~߂ȂAcDESSĒǉ
							diffMap.put(dp, color);
							while (dip.hasNext()) {
								diffMap.put(dip.next(), color);
							}
							break;
						}
						sp = sip.next();
								
					} else if (0 < compared) {
						diffMap.put(dp, color);
						if (!dip.hasNext()) { //DESł~߂ȂAcSRCnullǉ
							putNull(diffMap, sp);
							while (sip.hasNext()) {
								putNull(diffMap, sip.next());
							}
							break;
						}
						dp = dip.next();

					} else {
						break; 
					}
				} while(true);
			}
		}
	}

	/**
	 * ΂̒uꍇɂ̂nullB
	 * ^[Point, Color]łB
	 */
	private void putNull(Map<SgfPoint, SgfColor> map, SgfPoint key) {
		if (!map.containsKey(key)) { 
			map.put(key, null);
		}
	}

	
	/**
	 * RE̒̎ԂɂȂꍇtrueԂ܂B
	 */
	private boolean isKoViolation(
	        StoneGroup group, SgfPoint move, SgfPoint lastMove, Stone[] lastCaptured) 
	{
		assert(group != null && move != null && lastMove != null && lastCaptured != null);
		return (lastCaptured.length == 1) && move.equals(lastCaptured[0].getPoint())
				&& (group.count() == 1) && group.stones().contains(lastMove);
	}
	
	/**
	 * point̊_T܂B<br>
	 * ̓Iɂ͗אړ_̓A_TĕԂ܂B
	 */
	private Collection<SgfPoint> findLifePoints(SgfPoint point) {
		assert point != null;
		List<SgfPoint> lifePoints 
				= new ArrayList<SgfPoint>(SgfPoint.MAX_NEIGHBORS);
		for (SgfPoint sgfPoint : point.neighbors()) {
			if (isEmpty(sgfPoint)) {
				lifePoints.add(sgfPoint);
			}
		}
		return lifePoints;		
	}

	/** point_ł΁ipointɐ΂΁jtrueԂ܂B*/
	private boolean isEmpty(SgfPoint point) {
		assert point != null;
		return !allStones_.containsKey(point);
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.board.IgoBoardView#position(org.unitarou.sgf.type.SgfColor)
	 */
	public SortedSet<SgfPoint> position(SgfColor color) {
		ArgumentChecker.throwIfNull(color);
		
		SortedSet<SgfPoint> stones = new TreeSet<SgfPoint>();
		Set<StoneGroup> stoneGroups = getStoneGroups(color);
		for (StoneGroup stoneGroup : stoneGroups) {
			stones.addAll(stoneGroup.stones());
		}
		return stones;
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.board.IgoBoardView#size()
	 */
	public SgfSize size() {
		return size_;
	}
		
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.board.IgoBoardView#getCaptured(org.unitarou.sgf.type.SgfColor)
	 */
	public List<Stone> getCaptured(SgfColor playerColor) {
		ArgumentChecker.throwIfNull(playerColor);
		List<Stone> ret = new ArrayList<Stone>(captured_.size());
		for (Stone stone : captured_) {
			if (playerColor.opposite().equals(stone.getColor())) {
				ret.add(stone);
			}
		}
		return ret;
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.board.IgoBoardView#getCaptured()
	 */
	public List<Stone> getCaptured() {
		return Collections.unmodifiableList(captured_);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.board.IgoBoardView#getStone(org.unitarou.sgf.type.SgfPoint)
	 */
	public Stone getStone(SgfPoint point) {
	    ArgumentChecker.throwIfNull(point);
	    return allStones_.get(point);
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.board.IgoBoardView#lifePoint(org.unitarou.sgf.type.SgfPoint)
	 */
	public int lifePoint(SgfPoint point) {
		ArgumentChecker.throwIfNull(point);
		
		for (StoneGroup stoneGroup : blackGroups_) {
			if (stoneGroup.contains(point)) {
			    return stoneGroup.countLifePoint();
			}
		}

		for (StoneGroup stoneGroup : whiteGroups_) {
			if (stoneGroup.contains(point)) {
			    return stoneGroup.countLifePoint();
			}
		}

	    return -1;
	}
	

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.board.IgoBoardView#validate()
	 */
    public Set<SgfPoint> validate() {
        // d{@link SgfPoint}̏WłB
        Set<SgfPoint> ret = new HashSet<SgfPoint>();

        // ݕێĂS{@link SgfPoint}̏WłB
        Set<SgfPoint> all = new HashSet<SgfPoint>();
        
        ret.addAll(validateImpl(blackGroups_, all));
        ret.addAll(validateImpl(whiteGroups_, all));
        return ret;
    }
    
    /**
     * {@link #validate()}̎łB
     * stoneGroupsɂ{@link #blackGroups_}{@link #whiteGroups_}܂B
     * 
     * @param all ܂łɂ̃\bhŃ`FbNꂽS΂̍W{@link SgfPoint}łB
     * @return d{@link SgfPoint}̏W
     */
    private Set<SgfPoint> validateImpl(Set<StoneGroup> stoneGroups, Set<SgfPoint> all) {
        // d{@link SgfPoint}̏WłB
        Set<SgfPoint> ret = new HashSet<SgfPoint>();
        
        for (StoneGroup stoneGroup : stoneGroups) {
            for (SgfPoint sgfPoint : stoneGroup.stones()) {
                if (all.contains(sgfPoint)) {
                    ret.add(sgfPoint);
                } else {
                    all.add(sgfPoint);
                }
            }
        }
        return ret;
    }
	// ܂ŎQƌn\bh
}
