/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.board;

import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.Stone;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public interface IgoBoardView {

	// Qƌn\bh
	/**
	 * pointcolor̐΂uƂoȂꍇtrueԂ܂B
	 * ̓Iɂ́Aɐ΂AEAREɂ֎~_ł͂Ȃꍇ
	 * falseԂ܂B
	 * ړ̗RlastMovewłȂꍇ̓pXݒ肵܂B
	 * @throws NullArgumentException null̏ꍇ
	 */
	boolean isForbiddenMove(SgfPoint point, SgfColor color, SgfPoint lastMove,
			Stone[] lastCaptured);

	/**
	 * srcƂ̍i΂̏Aグꂽ΂̏j܂B
	 * target.diff(src);̖߂lsrcɐݒ肷邱ƂŁAtargetƓԂ܂B
	 * 
	 * ȉ̐΂Ƌ_̓[Point, Color]̌^ŕԂ܂B
	 * (1)srcɂ݂͑ĂȂāÃCX^Xɂ݂͑΂<br>
	 * (2)srcɑ݂ĂāÃCX^Xɂ݂͑Ȃ΂_Ƃ<br>
	 * _ColornullƂȂ܂B
	 * @return 
	 * @throws IllegalArgumentException src̔ՃTCYƂ̔Ղ̃TCYقȂꍇ
	 */
	SortedMap<SgfPoint, SgfColor> diff(IgoBoard src);

	/**
	 * ǖʂ̑SĂ̐΂Ԃ܂B
	 * @return ǖʂ̑SĂ̐
	 * @throws NullArgumentException <code>null</code>̏ꍇ
	 */
	SortedSet<SgfPoint> position(SgfColor color);

	SgfSize size();

	/**
	 * AQn}̏W𕡎ʂĕԂ܂B
	 * @param playerColor vC[̐F(Ȃ甒΂AȂ獕΂Ԃ)
	 * @return
	 * @deprecated ̃\bhĂяo߂ɁAŌՂXV邽߃ptH[}Xɖ肪B
	 *               {@link org.unitarou.yukinoshita.model.NodeView#getCaptured(SgfColor)}g
	 */
	@Deprecated 
	List<Stone> getCaptured(SgfColor playerColor);

	/**
	 * AQn}̏WҏWs\ȏWƂĕԂ܂B
	 * @param sgfColor
	 * @return
	 * @deprecated ̃\bhĂяo߂ɁAŌՂXV邽߃ptH[}Xɖ肪B
	 *               {@link org.unitarou.yukinoshita.model.NodeView#getCaptured(SgfColor)}g
	 */
	@Deprecated
	List<Stone> getCaptured();

	/**
	 * pointɂ΂Ԃ܂B
	 * ݂ȂꍇnullԂ܂B
	 * @param point 擾΂̏ꏊ
	 * @return pointɂ΁A݂Ȃꍇnull
	 * 
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇB
	 */
	Stone getStone(SgfPoint point);

	/**
	 * point܂ސ΂̃_̐𐔂ĕԂ܂B
	 * ɐ΂Ȃꍇ-1Ԃ܂B
	 * @param point
	 * @return
	 */
	int lifePoint(SgfPoint point);

	/**
	 * ΂dȂĂs{@link SgfPoint}̏WԂ܂B
	 * @return ^{@link SgfPoint}
	 */
	Set<SgfPoint> validate();
}