/* InheritableMarker.java
 * 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.board;

import java.util.SortedMap;
import java.util.TreeMap;

import org.unitarou.lang.NullArgumentException;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;

/**
 * CvpeB̓A
 * p(ONode̒lp)CvpeBێNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class InheritableMarker {
    
    /**
     * ^[SgfId, String[]:value]łB
     */
    private final SortedMap<SgfId, String[]> inheritablePropertyMap_;

    /**
     * 
     */
    public InheritableMarker() {
        super();
        inheritablePropertyMap_ = new TreeMap<SgfId, String[]>();
    }
    
    /**
     * propertyValueso^܂B
     * nullPropertyTypeINHERITȊȌꍇ͖܂B
     * ȑO̒l̓NA[܂B
     */
    public void set(Property property) {
        if (property == null) {
            return;
        }
        SgfId sgfType = property.sgfId();
        if (!sgfType.propertyType().equals(PropertyType.INHERIT)) {
            return;
        }
        inheritablePropertyMap_.remove(property.sgfId());
        inheritablePropertyMap_.put(sgfType, property.getStrings());
    }
    
    /**
     * inheritedDecorationɊSɒu܂B
     * @throws NullArgumentException null̏ꍇB
     */
    public void set(InheritableMarker inheritableDecoration) {
        if (inheritableDecoration == null) {
            throw new NullArgumentException("inheritableDecoration must not be null"); //$NON-NLS-1$
        }
        inheritablePropertyMap_.clear();
        inheritablePropertyMap_.putAll(inheritableDecoration.inheritablePropertyMap_);
    }
    
    /**
     * ݕێĂCvpeB܂B
     */
    public void clear() {
        inheritablePropertyMap_.clear();
    }
    

    /**
     * typeɕRÂvalue̔zԂ܂B
     * ȂAݒ肳ĂȂꍇA
     * NONE(g[]h)ݒ肳ĂꍇnullԂAO̔z͕Ԃ܂B 
     * @throws NullArgumentException typenull̏ꍇ
     */
    public String[] get(SgfId type) {
        if (type == null) {
            throw new NullArgumentException("type must not be null"); //$NON-NLS-1$
        }
        String[] ret = inheritablePropertyMap_.get(type);
        return isEmptyValue(ret) ? null : ret;
    }
    
    /**
     * valuesSGF̒`猩EMPTY̏ꍇtrueԂ܂B
     * ̓IɂvaluesnullO̔z񂩁APŋ󕶎ĂꍇłB
     */
    private boolean isEmptyValue(String[] values) {
        return (values == null) || (values.length == 0)
        		|| ((values.length == 1) && (values[0].equals(Strings.EMPTY)));
    }
}
