/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.board;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.util.ArgumentChecker;

/**
 * LBAARALNƂÃubN܂ĕ`悳
 * CvpeBێNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class OverblockMarker {
    /** ̃NXΉĂ{@link SgfId}̏WłB */
    static private final Set<SgfId> targetTypeSet_s_;
    static  {
        targetTypeSet_s_ = new TreeSet<SgfId>();
        targetTypeSet_s_.add(SgfId.LABEL);
        targetTypeSet_s_.add(SgfId.LINE);
        targetTypeSet_s_.add(SgfId.ARROW);
    }
    

    /** ^[{@link SgfId}, Set[String]]*/
    private final Map<SgfId, Set<String>> typeValueMap_;

    /**
     * 
     */
    public OverblockMarker() {
        super();
        typeValueMap_ = new TreeMap<SgfId, Set<String>>();
    }

    /**
     * 
     */
    public OverblockMarker(Node node) {
        super();
        ArgumentChecker.throwIfNull(node);
        typeValueMap_ = new TreeMap<SgfId, Set<String>>();
        for (Property property : node.getProperties()) {
        	setImpl(property);
        }
    }

    /**
     * propertyValueso^܂B
     * nullIDLBAARALNȊO̒l͖܂B
     * ȑO̒l̓NA[܂B
     */
    public void set(Property property) {
    	setImpl(property);
    }
    
    private void setImpl(Property property) {
        if (property == null) {
            return;
        }
        SgfId sgfType = property.sgfId();
        if (!targetTypeSet_s_.contains(sgfType)) {
            return;
        }

        Set<String> valueSet = typeValueMap_.get(sgfType);
        if (valueSet != null) {
            valueSet.clear();
        } else {
            valueSet = new TreeSet<String>();
            typeValueMap_.put(sgfType, valueSet);
        }
        valueSet.addAll(Arrays.asList(property.getStrings()));
    	
    }
    
    /**
     * overblockMarkerɊSɒu܂B
     * @throws NullArgumentException null̏ꍇB
     */
    public void set(OverblockMarker overblockMarker) {
        ArgumentChecker.throwIfNull(overblockMarker);
        typeValueMap_.clear();
        typeValueMap_.putAll(overblockMarker.typeValueMap_);
    }

    /**
     * @param sgfType
     * @return
     */
    public String[] get(SgfId sgfType) {
        ArgumentChecker.throwIfNull(sgfType);

        Set<String> dataSet = typeValueMap_.get(sgfType);
        if (dataSet == null) {
            return new String[0];
        }
        return dataSet.toArray(new String[dataSet.size()]);
    }
    
    /**
     * ݕێĂ郉ẍꗗԂ܂B
     * sizi{@link Label}CX^X쐬łɕKvłB
     * @throws NullArgumentException null̏ꍇ 
     */
    public Label[] getLabels(SgfSize size) {
        ArgumentChecker.throwIfNull(size);
        
        String[] data = get(SgfId.LABEL);
        List<Label> labelList = new ArrayList<Label>(data.length);
        for (int i = 0; i < data.length; ++i) {
        	Label label = Label.parseQuietly(size, data[i]);
        	if (label != null) {
                labelList.add(label);
        	}
        }
        return labelList.toArray(new Label[labelList.size()]);
    }

    /**
     * ݕێĂ{@link SgfLine}̈ꗗԂ܂B
     * 
     * @throws NullArgumentException null̏ꍇ
     * @throws IllegalArgumentException sgfTypeValueTypeCPOINTȊȌꍇ
     */
    public SgfLine[] getLine(SgfId sgfType, SgfSize size) {
        ArgumentChecker.throwIfNull(sgfType, size);
        if (!sgfType.valueType().equals(ValueType.CPOINT)) {
            throw new IllegalArgumentException("Bad type for getLine():" + sgfType); //$NON-NLS-1$
        }
        
        String[] data = get(sgfType);
        List<SgfLine> lineList = new ArrayList<SgfLine>(data.length);
        for (int i = 0; i < data.length; ++i) {
            try {
                lineList.add(SgfLine.parse(size, data[i]));
            } catch (TypeParseException ignore) {
                // TODO Auto-generated catch block
                ignore.printStackTrace();
            }
        }
        return lineList.toArray(new SgfLine[lineList.size()]);
    }

    /**
     * @return
     */
    public boolean isEmpty() {
        for (Iterator ip = typeValueMap_.values().iterator(); ip.hasNext(); ) {
            Set dataSet = (Set)ip.next();
            if (!dataSet.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    /**
     * 
     */
    public void clear() {
        typeValueMap_.clear();
    }

}
