/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.board;

import java.util.Collection;
import java.util.Set;

import org.unitarou.lang.DisposedInstanceException;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.util.ArgumentChecker;

/**
 * ĂQ̐΂\NXłB
 * t@XJE^[Ă̂ŁA
 * CX^Xjꍇ{@link dispose()}Ăт܂傤B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public final class StoneGroup implements Comparable {
	private StoneGroupImpl impl_;
	
	
	// \zn\bh
	/**
	 * 
	 */
	public StoneGroup(SgfSize size) {
		super();
		ArgumentChecker.throwIfNull(size);
		impl_ = new StoneGroupImpl(size);
	}
	
	/**
	 * Rs[RXgN^[łB
	 * @param src
	 */
	public StoneGroup(StoneGroup src) {
		super();
		ArgumentChecker.throwIfNull(src);
		impl_ = new StoneGroupImpl(src.impl_);
	}
	
	private StoneGroup(StoneGroupImpl impl) {
	    super();
	    assert impl != null;
		impl_ = new StoneGroupImpl(impl);
	}
	// ܂ō\zn\bh
	 


	// ύXn\bh
	/**
	 * point̃O[vɐڑ\
	 *i㉺ẺꂩɋߐڂĂjȏꍇ̂݁A
	 * pointǉtrueԂ܂B<br>
	 * lifePointspoint̊_point̗אړ_őɐ΂݂ȂWłB
	 * 
	 * @param point
	 * @param lifePoints
	 * @return
	 * @throws NullArgumentException <code>null</code>̏ꍇ
	 * @throws DisposedInstanceException łɔjĂꍇB
	 */
	public boolean add(SgfPoint point, Collection<SgfPoint> lifePoints) {
		ArgumentChecker.throwIfNull(point, lifePoints);
		return impl_.add(point, lifePoints);
	}

	public void add(StoneGroup src) {
		ArgumentChecker.throwIfNull(src);
		impl_.add(src.impl_);
	}
	
	/**
	 * point̐΂菜܂B
	 * ߂l͕ʂ͂̃CX^Xĝ݂Ă܂A
	 * 菜ƂɂăO[vꍇ́A
	 * ꂽO[vׂĂ܂B
	 * ܂z̍ŏ̗vfɂ͎g邱Ƃۏ؂܂B
	 * @throws NullArgumentException null̏ꍇ
	 * @throws IllegalArgumentException point̐΂̃O[vȂꍇ
	 */
	public StoneGroup[] remove(SgfPoint point) {
		ArgumentChecker.throwIfNull(point);
		if (!impl_.contains(point)) {
		    throw new IllegalArgumentException();
		}
		
		StoneGroupImpl[] impls = impl_.remove(point);
		impl_ = impls[0];
		
		StoneGroup[] groups = new StoneGroup[impls.length];
		groups[0] = this;
		for (int i = 1; i < impls.length; ++i) {
		    groups[i] = new StoneGroup(impls[i]);
		}
		
		return groups;
	}

	/** point̐΂グꂽ̂ŁA_𑝂₵܂B*/
	public void addLifePoint(SgfPoint point) {
		ArgumentChecker.throwIfNull(point);
		if (impl_.isNeighbor(point)) {
			impl_.addLifePoint(point);
		}
	}

	/** 
	 * point̃_l߂܂B_OɂȂꍇ
	 * i܂A񂾏ꍇjtrueԂ܂B
	 * EȂǂŊɎłꍇfalseԂ܂B
	 */
	public boolean removeLifePoint(SgfPoint point) {
		ArgumentChecker.throwIfNull(point);
		if (impl_.isLifePoint(point)) {
			return impl_.removeLifePoint(point);
		}
		return false;
	}
	// ܂ŕύXn\bh


	// Qƌn\bh
	/** ̃O[v̐΂̏WԂ܂B
	 * ̏W͕ύX邱Ƃo܂B
	 * @return ^[{@link SgfPoint}]łB
	 */
	public Set<SgfPoint> stones() {
		return impl_.stones();
	}

	/**
	 * {@link #impl_}mrēΓƂ݂Ȃ܂B
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		} else if ( (obj == null) || (obj.getClass() == this.getClass())) {
			return false;

		} 
		
		return impl_.equals(((StoneGroup)obj).impl_);
	}
	

    /**
     * Ńt@XJE^[ĂāA
     * ɂimpl_؂ւ̂ŁAg̃nbVlpB
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
	public int hashCode() {
		return super.hashCode();
    }
    
	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(T)
	 */
	public int compareTo(Object o) {
		StoneGroup des = (StoneGroup)o;
		return System.identityHashCode(this.impl_) - System.identityHashCode(des.impl_);
	}

	/** ΂̐Ԃ܂B*/
	public int count() {
		return impl_.count();
	}

	/** _̐Ԃ܂B*/
	public int countLifePoint() {
		return impl_.countLifePoint();
	}

	/** point̃O[vɊ܂܂ĂȂtrueԂ܂B*/
	public boolean contains(final SgfPoint point) {
		return impl_.contains(point);
	}

	/** point̃O[ṽ_ȂtrueԂ܂B
	 */
	public boolean isLifePoint(final SgfPoint point) {
		return impl_.isLifePoint(point);
	}
	// ܂ŎQƌn\bh

}
