/* StoneGroupImpl.java
 * 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.board;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFormatter;

/**
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
final public class StoneGroupImpl {
	/** ̃O[vՂ̑傫łB*/
	private final SgfSize size_;
	
	/** ^[{@link SgfPoint}]łB̃O[v̐΂SēĂ܂B*/
	private final Set<SgfPoint> stones_;
	
	/** ^[{@link SgfPoint}]łB̃O[v̗אړ_SēĂ܂B*/
	private final Set<SgfPoint> neighbors_;
	
	/** ^[{@link SgfPoint}]łB̃O[v̊_i_jSēĂ܂B
	 * neighbors_lifePoints_łB*/
	private final Set<SgfPoint> lifePoints_;

	/**
	 * 
	 */
	StoneGroupImpl(final SgfSize size) {
		super();
		assert(size != null);
		size_ = size;
		stones_ = new TreeSet<SgfPoint>();
		neighbors_ = new TreeSet<SgfPoint>();
		lifePoints_ = new TreeSet<SgfPoint>();
	}
	
	/**
	 * {@link org.unitarou.memory.ReferenceCounter}Ăяo悤ɁA
	 * publicɂĂ܂B
	 */
	public StoneGroupImpl(final StoneGroupImpl src) {
		if (src == null) {
			throw new NullArgumentException();
		}
		size_ = src.size_;
		stones_ = new TreeSet<SgfPoint>(src.stones_);
		neighbors_ = new TreeSet<SgfPoint>(src.neighbors_);
		lifePoints_ = new TreeSet<SgfPoint>(src.lifePoints_);
	}
	 

	/**
	 * point̃O[vɐڑ\
	 *i㉺ẺꂩɋߐڂĂjȏꍇ̂݁A
	 * pointǉtrueԂ܂B<br>
	 * lifePointspoint̊_point̗אړ_őɐ΂݂ȂWłB
	 * 
	 * @param point
	 * @param lifePoints
	 * @return
	 */
	boolean add(SgfPoint point, Collection<SgfPoint> lifePoints) {
		assert (point != null && lifePoints != null);
		
		if (!size_.equals(point.size())) {
			throw new IllegalArgumentException("Bad size " + size_ + "!=" + point.size());  //$NON-NLS-1$//$NON-NLS-2$
		} 
		
		if (!lifePoints_.contains(point) && !lifePoints_.isEmpty()) {
			return false;
		}
		stones_.add(point);
		
		// O[v̐΂΁Aאړ_Ƃēo^B
		for (SgfPoint neighbor : point.neighbors()) { 
			if (!stones_.contains(neighbor)) {
				neighbors_.add(neighbor);
			}
		}
		
		// _XVB
		// ΂uƂ̊_͍폜A
		// ̐΂̊_̃O[vɒǉB
		lifePoints_.remove(point);
		for (SgfPoint lifePoint : lifePoints) {
			if (stones_.contains(lifePoint)) {
				throw new IllegalArgumentException(
						lifePoint + " does not touch this group" //$NON-NLS-1$
						+ BasicFormatter.format(stones_));
			}
			lifePoints_.add(lifePoint);
		}
		return true;
	}
	
	
	/**
	 * srcSẴO[vɒǉ܂B
	 * Ă邩ɂĒׂȂ̂ŒӁB
	 * 
	 */
	void add(StoneGroupImpl src) {
		assert(src != null);
		
		stones_.addAll(src.stones_);
		neighbors_.addAll(src.neighbors_);
		lifePoints_.addAll(src.lifePoints_);
		for (Iterator ip = stones_.iterator(); ip.hasNext(); ) {
			lifePoints_.remove(ip.next());
		}
	}

	/**
	 * point폜܂Bpoint̃O[vɑ݂ĂKv܂B
	 * TODO ΂ɕʂꂽꍇ̏ȂB
	 */
	StoneGroupImpl[] remove(SgfPoint point) {
		assert(point != null && stones_.contains(point));
		
		stones_.remove(point);
		lifePoints_.add(point);
		
		// _XV
		for (Iterator ip = point.neighbors().iterator(); ip.hasNext(); ) {
			SgfPoint neighbor = (SgfPoint)ip.next();
			if (!lifePoints_.contains(neighbor)) {
				continue;
			}
			
			boolean noContact = true;
			for (Iterator jp = neighbor.neighbors().iterator(); jp.hasNext(); ) {
				if (stones_.contains(jp.next())) {
					noContact = false;
					break;
				}
			}
			if (noContact) {
				lifePoints_.remove(neighbor);
			}
		}
		
		// neighbor̍XVΏۂi荞ނ̂ʓ|Ȃ̂ŁA
		// neighborsŜ폜č\ȂĂB
		neighbors_.clear();
		for (Iterator ip = stones_.iterator(); ip.hasNext(); ) {
		    SgfPoint point2 = (SgfPoint)ip.next();
		    neighbors_.addAll(point2.neighbors());
		}

		//ꂽǂ̃`FbŃF
		// n_IÂ݂ǂ̃O[vɂ݂ȂꍇF
		// 瓞Bł邷ׂĂ̐΂W߁AO[vƂB
		// ̃O[v̏WɉB
		//
		/** ^[{@link StoneGroupImpl] */
		Set<StoneGroupImpl> implSet = new HashSet<StoneGroupImpl>();
		for (Iterator ip = stones_.iterator(); ip.hasNext(); ) {
		    SgfPoint point2 = (SgfPoint)ip.next();
		    boolean exists = false;
		    for (Iterator<StoneGroupImpl> jp = implSet.iterator(); jp.hasNext(); ) {
		        StoneGroupImpl impl = jp.next();
		        if (impl.stones_.contains(point2)){
		            exists = true;
		            break;
		        }
		    }
		    if (exists) {
		        continue;
		    }
		    
		    StoneGroupImpl impl = new StoneGroupImpl(size_);
		    impl.trace(point2, this);
		    implSet.add(impl);
		}
		
		//implSet̏ꍇ́ÃCX^X̓ԂNA[āA
		//go^B
		if (implSet.isEmpty()) {
		    neighbors_.clear();
		    lifePoints_.clear();
		    implSet.add(this);
		}
		
		return implSet.toArray(new StoneGroupImpl[implSet.size()]);
	}
	
	/**
	 * mother̂ƂāA
	 * pointƘAĂS΂Agɒǉ܂B
	 * LifePointneighborǉ܂B
	 */
	private void trace(SgfPoint point, StoneGroupImpl mother) {
	    stones_.add(point);
	    for (Iterator ip = point.neighbors().iterator(); ip.hasNext(); ) {
	        SgfPoint point2 = (SgfPoint)ip.next();
	        if (mother.lifePoints_.contains(point2)) {
	            lifePoints_.add(point2);
	        }
	        if (!stones_.contains(point2)) {
	            neighbors_.add(point2);
		        if (mother.stones_.contains(point2)) {
		            trace(point2, mother);
		        }
	        }
	    }
	}

	/** i΂グꂽ̂Łj_𑝂₵܂B*/
	void addLifePoint(SgfPoint point) {
		assert(point != null); 
		lifePoints_.add(point);		
	}
	
	/** 
	 * point̃_l߂܂B_OɂȂꍇ
	 * i܂A񂾏ꍇjtrueԂ܂B
	 * EȂǂŊɎłꍇfalseԂ܂B
	 */
	boolean removeLifePoint(SgfPoint point) {
		assert(point != null); 
		if (lifePoints_.remove(point)) {
			return lifePoints_.isEmpty();
		}
		return false;
		
	}
	
	/** ̃O[v̐΂̏WԂ܂B
	 * ̏W͕ύX邱Ƃo܂B
	 * @return ߂ľ^[{@link SgfPoint}]łB
	 */
	Set<SgfPoint> stones() {
		return Collections.unmodifiableSet(stones_);
	}
	
	/** ΂̐Ԃ܂B*/
	int count() {
		return stones_.size();
	}
	
	/** _̐Ԃ܂B*/
	int countLifePoint() {
		return lifePoints_.size();
	}

	/** point̃O[vɊ܂܂ĂȂtrueԂ܂B
	 */
	boolean contains(SgfPoint point) {
		return stones_.contains(point);
	}

	/** point̃O[vɐڑ\
	 * i㉺ẺꂩɗאڂĂjȂtrueԂ܂B
	 */
	boolean isNeighbor(SgfPoint point) {
		return neighbors_.contains(point);
	}
	
	/** point̃O[ṽ_ȂtrueԂ܂B*/
	boolean isLifePoint(SgfPoint point) {
		return lifePoints_.contains(point);
	}

}
