/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.EditableNodeList;

/**
 * ݂̃m[h̒ɁAǉ܂B<br>
 * yfXVnFUNDO\z
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class AddMove extends AddNode {
	/** u[{0}]v */
	static private final MessageResource LB_NAME 
		= new MessageResource(AddMove.class, "lbName"); //$NON-NLS-1$

	private final SgfColor color_;
	private final SgfPoint point_;
	

	/**
	 * colorŎw肳ꂽ΂pointŎw肳ꂽʒuɒ肷R}h쐬܂B<br>
	 * ݂͌̒胊Xg̍Ŋɒǉ܂B
	 * RE⒅֎~_̃`FbN͍s܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException ̂ꂩłnull̏ꍇB
	 */
	public AddMove(SgfColor color, SgfPoint point) {
		super(Node.makeMoveNode(color, point));
		color_ = color;
		point_ = point;
	}


	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getDisplayName()
	 */
	@Override
	public String displayName() {
		CoordinatesLabelProvider provider = 
				Yukinoshita.context().getProvider(
						CoordinatesLabelProvider.class, getRoot());
		setDisplayName(LB_NAME.get(
				color_.displayName() + ':' +
				provider.getMoveLabel(point_)));
		return super.displayName();
	}
	
	/**
	 * {@link Command4NodeList#getEditableNodeList()}lԂ
	 * {@link EditableNodeList#getRoot()}AԂȂ(nullԂ)Ƃ
	 * nullԂ܂B
	 * @return
	 */
	private RootGameTree getRoot() {
		EditableNodeList editableNodeList = getEditableNodeList();
		if (editableNodeList != null) {
			return editableNodeList.getRoot();
		}
		return null;
	}
	
	
}
