/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;

import org.unitarou.cmd.Command;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeTree;

/**
 * {@link org.unitarou.yukinoshita.model.EditableNodeList}̍Ō
 * {@link org.unitarou.sgf.Node}ǉR}hłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class AddNode extends Command4NodeList {
	/** um[h𖖔ɒǉv */
	static private final MessageResource LB_NAME = new MessageResource(AddNode.class, "lbName"); //$NON-NLS-1$
	
	/**
	 * ǉm[hłBRXgN^Ŏw肳܂B
	 */
	private final Node node_;
	private Command sgfCommand_;
	private GameTree gameTree_;
	/**
	 * ǉm[hGeBeBłB
	 */
	private NodeEntity addNodeEntity_;

	/**
	 * ǉm[hnodeŎw肵܂B
	 * ǉ{@link Command4NodeList#setEditableNodeList(EditableNodeList)}
	 * NCAgw肵܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 */
	public AddNode(Node node) {
		super();
		ArgumentChecker.throwIfNull(node);
		node_ = node;
		setDisplayName(LB_NAME.get());
	}
	
	/**
	 * {@link Command4NodeList#getEditableNodeList()}
	 * p[^\܂B
	 * \ɐꍇA܂͂łɍ\ĂꍇtrueԂ܂B
	 * @return
	 */
	@Override
	protected boolean setup() {
		if (sgfCommand_ != null) {
			return true;
		}
		EditableNodeList nodeList_ = getEditableNodeList();
		if (nodeList_ == null) {
			return false;
		}
		NodeTree nodeTree = nodeList_.getLast().getNodeTree();
		sgfCommand_ = new org.unitarou.sgf.cmd.AddNode(nodeTree.getGameTree(), node_);
		gameTree_ = nodeTree.getGameTree();
		addNodeEntity_ = new NodeEntity(
				node_, 
				gameTree_, 
				nodeList_, 
				nodeList_.size() == 0 ? null : nodeList_.getLast());
		setExecutedNodeIndex(nodeList_.size());
		setUndoneNodeIndex(nodeList_.size() - 1);
		return true;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		sgfCommand_.execute();
		getEditableNodeList().addLast(addNodeEntity_);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		sgfCommand_.undo();
		NodeEntity removed = getEditableNodeList().removeLast();
// 		assert removed == addNodeEntity_ 
// 				: "Mismatch target node: " + removed + " <> " + addNodeEntity_;  //$NON-NLS-1$//$NON-NLS-2$
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getCommandInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		return EnumSet.of(ModelInfluence.NODE_CURRENT);
	}
}
