/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import java.util.LinkedList;

import org.unitarou.cmd.Command;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.cmd.CreateGameTree;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.Stone;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;

/**
 * TODO ̂肩yk_214̌
 * 
 * pointcolorŎw肵ω}쐬܂B
 * colornullɂȂ肦܂B
 * 1. color == null̏ꍇF͖ω}쐬B
 * 2. color != null, point == null̏ꍇFcolor̎ԂŃpXn܂ω}쐬B
 * 3. color != null, point != null̏ꍇFcolor̎Ԃpoint̎肩n܂ω}쐬B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class AddVariation extends Command4NodeList {
	/** uω}ǉ({1})v */
	static private final MessageResource LB_NAME 
			= new MessageResource(AddVariation.class, "lbName"); //$NON-NLS-1$

	/** u薳v */
	static private final MessageResource LB_NO_MOVE 
			= new MessageResource(AddVariation.class, "lbNoMove"); //$NON-NLS-1$

	private final GameTree newTree_;
	/** ^{@link NodeEntity}łB*/
	private LinkedList<NodeEntity> lastChain_;

	private NodeEntity baseEntity_;
	private Command sgfCommand_;
	private EnumSet<ModelInfluence> influences_;

	/**
	 * ݂̃m[h̒ɁA
	 * colorŎw肳ꂽ΂pointŎw肳ꂽʒuɒ肵ω}}܂B
	 * ̌A̕ω}IԂɍXV܂B
	 * @throws org.unitarou.lang.NullArgumentException colorpoint<code>null</code>̏ꍇ
	 */
	public AddVariation(SgfColor color, SgfPoint point) {
		super();
	    ArgumentChecker.throwIfNull(color, point);
	    
		Node node = Node.makeMoveNode(color, point);
		GameTree newTree = new GameTree();
		newTree.getSequence().addFirst(node);					
		newTree_ = newTree;
		lastChain_ = null;
		baseEntity_ = null;
		sgfCommand_ = null;
		influences_ = null;
	}
	
	/**
	 * {@link Command4NodeList#getEditableNodeList()}
	 * p[^\܂B
	 * \ɐꍇA܂͂łɍ\ĂꍇtrueԂ܂B
	 * @return
	 */
	@Override
	protected boolean setup() {
		if (lastChain_ != null) {
			return true;
		}
		EditableNodeList nodeList_ = getEditableNodeList();
		if (nodeList_ == null) {
			return false;
		}
		
		baseEntity_ = nodeList_.getPosition();
		lastChain_ = new LinkedList<NodeEntity>();
		
		influences_ = baseEntity_.getNodeTree().isChildrenStyle()
				? EnumSet.of(ModelInfluence.NODE_PEVIOUS) 
				: EnumSet.of(ModelInfluence.NODE_CURRENT); 
				
		setExecutedNodeIndex(nodeList_.getPositionIndex() + 1);
		setUndoneNodeIndex(nodeList_.getPositionIndex() + 1);
		return true;
	}

	/**
	 * W̕\`͂̏uԂ̃voC_[Ɉˑ̂ŁA
	 * \̒O{@link #composeDisplayName()}ōXVĂ܂B
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#displayName()
	 */
	@Override
	public String displayName() {
		composeDisplayName();
		return super.displayName();
	}

	/**
	 * ω}̐擪̏ꍇ͂̒̐FƍW
	 * DisplayNameƂĐݒ肵܂B
	 */
	private void composeDisplayName() {
		setDisplayName(LB_NAME.get(LB_NO_MOVE.get()));
		if (newTree_.getSequence().size() == 0 || !setup()) {
			return;
		} 
		
		Stone stone = Stone.create(newTree_.getSequence().getFirst(),
								   getEditableNodeList().getSize());
		if (!stone.isValid()) {
			return;
		}

		CoordinatesLabelProvider provider = 
				Yukinoshita.context().getProvider(
						CoordinatesLabelProvider.class, 
						baseEntity_.getNodeTree().getRootGameTree());
		setDisplayName(LB_NAME.get(
				stone.getColor().displayName() + ':' +
				provider.getMoveLabel(stone.getPoint())));
	}

	/** 
	 * ASŶ͎ƂF
	 * <ol>
	 * <li>SGF̃fXV{@link Command}sB</li>
	 * <li>ϐ̑}_܂{@link NodeEntity}폜B</li>
	 * <li>폜{@link NodeEntity}͕ێiundoŎgjB</li>
	 * <li>}_ɐV{@link GameTree}̒g{@link org.unitarou.sgf.Node}B</li>
	 * </ol> 
	 *  
	 * @see org.unitarou.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();

		sgfCommand_ = new CreateGameTree(
				baseEntity_.getNodeTree().getGameTree(), 
				baseEntity_.getNode(), 
				newTree_);
		sgfCommand_.execute();

		EditableNodeList nodeList = getEditableNodeList();
		lastChain_.clear();
		NodeEntity last = nodeList.removeLast();
		while(!last.equals(baseEntity_)) {
			lastChain_.addFirst(last);
			last = nodeList.removeLast();
		}

		nodeList.addLast(baseEntity_); // baseEntity_͌ɖ߂B
		assert (Sgfs.getRoot(newTree_) instanceof RootGameTree) : "Bad type"; //$NON-NLS-1$

		NodeEntity topEntity = null;
		for (Node node : newTree_.getSequence()) {
			NodeEntity entity = nodeList.addLast(node, newTree_);
			topEntity = (topEntity == null) ? entity : topEntity;
		}

		
		// ChildrenX^CSiblingX^CɂSelection̎wꏊႤB
		int selectionId = baseEntity_.getNodeTree().getGameTree().getChildrenSize() - 1;
		if (last.getNodeTree().isChildrenStyle()) {
			last.setSelectedVariationIndex(selectionId);
			
		} else if (topEntity != null) {
			topEntity.setSelectedVariationIndex(selectionId);
		}
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		sgfCommand_.undo();

		NodeEntity last = getEditableNodeList().removeLast();
		while(!last.equals(baseEntity_)) {
			last = getEditableNodeList().removeLast();
		}
		getEditableNodeList().addLast(baseEntity_); // nodeView_͌ɖ߂B
		getEditableNodeList().addLast(
		        lastChain_.toArray(
		                new NodeEntity[lastChain_.size()]));
	}



	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getCommandInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		return influences_;
	}
}
