/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.io.File;
import java.util.EnumSet;

import org.apache.commons.io.FilenameUtils;

import org.unitarou.cmd.Command;
import org.unitarou.cmd.NullCommand;
import org.unitarou.io.Ios;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;

/**
 * t@CύXR}hłB<br>
 * W{@link org.unitarou.sgf.type.GameType#DRILL}̏ꍇ́A
 * Vt@C̑΃pXɂȂ悤ɁA
 * {@link org.unitarou.sgf.SgfId#INPUT_FILES}XV܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class ChangeFileName extends Command4NodeList {
	/** ut@CύXv */
	static private final MessageResource LB_NAME 
			= new MessageResource(ChangeFileName.class, "lbName"); //$NON-NLS-1$
	
	private final Collection collection_;
	private final File lastFile_;
	private final File newFile_;
	private Command command_;
	
	/**
	 * t@CύX{@link Collection}ƐV{@link File}w肵܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇB
	 */
	public ChangeFileName(Collection collection, File newFile) {
		super();
		ArgumentChecker.throwIfNull(collection, newFile);
		
		collection_ = collection;
		lastFile_ = collection.getFile();
		newFile_ = newFile;
		command_ =null;
		setDisplayName(LB_NAME.get());
	}

	


	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#setup()
	 */
	@Override
	protected boolean setup() {
		if (command_ != null) {
			return true;
		}
		if (getEditableNodeList() == null) {
			return false;
		}
		command_ = composeCommand();
		return true;
	}

	/**
	 * {@link #collection_}̐擪{@link GameType#DRILL}ŁA
	 * {@link Collection#getFile()}{@link #newFile_}̃fBNgقȂꍇ̂݁A
	 * {@link SgfId#INPUT_FILES}XV{@link UpdateProperty}
	 * Ԃ܂B<br>
	 * ȊȌł{@link NullCommand}Ԃ܂B
	 * @return
	 */
	private Command composeCommand() {
		if (!collection_.get(0).getGameType().equals(GameType.DRILL)) {
			return NullCommand.INSTANCE;
		}
		// DRILL̏ꍇ͕KFILE
		String old = FilenameUtils.getFullPath(collection_.getFile().getAbsolutePath());
		String now = FilenameUtils.getFullPath(newFile_.getAbsolutePath());
		if (old.equals(now)) {
			return NullCommand.INSTANCE;
		}
		
		EditableNodeList nodeList = getEditableNodeList();
		if (nodeList.size() < 2) {
			return NullCommand.INSTANCE;
		}
		
		// 擪TĈԍŏɌIFXVB
		for (int i = 0; i < nodeList.size(); ++i) {
			Property property = nodeList.get(i).getNode().getProperty(SgfId.INPUT_FILES);
			if (property == null) {
				continue;
			}
			
			setExecutedNodeIndex(nodeList.getPositionIndex());
			setUndoneNodeIndex(nodeList.getPositionIndex());
			nodeList.setPositionIndex(i);
			// U΃pX߂ĂAVt@CƂ̑΃pX߂B
			Property newProperty = new Property();
			newProperty.setEntireId(SgfId.INPUT_FILES.id());
			for (Value value : property.getValues()) {
				String filename = FilenameUtils.concat(old, value.getString());
				Value newValue = new Value(
						Ios.calcRelativePath(now, filename),
						value.getOpenUtr());
				newProperty.addValue(newValue);
			}
			return new UpdateCommand(property, newProperty, nodeList);
		}
		return NullCommand.INSTANCE;
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		command_.execute();
		collection_.setFile(newFile_);
	}


	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		collection_.setFile(lastFile_);
		command_.undo();
	}


	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		return EnumSet.of(ModelInfluence.COLLECTION);
	}
	
	
	private class UpdateCommand implements Command {
		private final UpdateProperty removeLast_;
		private final UpdateProperty addRepleaced_;

		private UpdateCommand(Property old, Property now, EditableNodeList nodeList) {
			removeLast_ = new UpdateProperty(new Property[]{old}, null, null);
			addRepleaced_ = new UpdateProperty(new Property[]{}, now, null);
			removeLast_.setEditableNodeList(nodeList);			
			addRepleaced_.setEditableNodeList(nodeList);			
		}
		/* (non-Javadoc)
		 * @see org.unitarou.cmd.Command#execute()
		 */
		public void execute() {
			removeLast_.execute();
			addRepleaced_.execute();
		}

		/* (non-Javadoc)
		 * @see org.unitarou.cmd.Command#undo()
		 */
		public void undo() {
			addRepleaced_.undo();
			removeLast_.undo();
		}
	}
}
