/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.lang.Strings;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.GameMediator;

/**
 * {@link org.unitarou.yukinoshita.model.EditableNodeList}ɑ΂đsR}h̒ۃNXłB
 * {@link org.unitarou.yukinoshita.model.EditableNodeList}̃Zb^[,Qb^[A
 * [U猩R}hǗł邱ƂƁA
 * R}hs_ł{@link org.unitarou.yukinoshita.model.NodeList}
 * CfbNXǗ_{@link org.unitarou.cmd.Command}ǉꂽ@\łB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
abstract public class Command4NodeList extends AbstractCommand implements NameDisplayable {
	
	/**
	 * R}h̑ΏۂƂȂ郂fłB
	 */
	private EditableNodeList editableNodeList_;
	
	
    /**
     * R}ĥ̖łB
     */
	private String displayName_;
	
	
	
	/**
	 * ݒڂĂ{@link org.unitarou.yukinoshita.model.NodeView}
	 * {@link org.unitarou.yukinoshita.model.NodeList}ɂ擪̃CfbNXŁA
	 * R}hsꂽ̍Ww܂B
	 */
	private int executedNodeIndex_;

	/**
	 * ݒڂĂ{@link org.unitarou.yukinoshita.model.NodeView}
	 * {@link org.unitarou.yukinoshita.model.NodeList}ɂ擪̃CfbNXŁA
	 * R}hUNDOꂽ̍Ww܂B
	 */
	private int undoneNodeIndex_;

	/**
	 * R}ĥ̖󕶎Ƃď܂B
	 * RXgN^ R}h̑ΏۂƂȂ郂fݒ肳Ă܂B
	 * {@link org.unitarou.cmd.Command#execute()}{@link org.unitarou.cmd.Command#undo()}
	 * sO{@link #setGameMediator(GameMediator)}Ń^[Qbgf
	 * w肷Kv܂E
	 */
	public Command4NodeList() {
		super();
		editableNodeList_ = null;
		displayName_ = Strings.EMPTY;
		executedNodeIndex_ = 0;
		undoneNodeIndex_ = 0;
	}
	
	
	/**
	 * R}h̑ΏۂƂȂ郂fԂ܂B
	 * @return Returns the gameMediator.
	 */
	final public EditableNodeList getEditableNodeList() {
		return editableNodeList_;
	}


	/**
	 * R}h̑ΏۂƂȂ郂fԂ܂B
	 * UNDO/REDOmɍs߁Axݒ肷邱Ƃ͂ł܂B
	 * ܂AgameMediatoro^悤ƂƖ܂B
	 * 
	 * @param editableNodeList The gameMediator to set.
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 * @throws IllegalStateException
	 *          {@link #gameMediator_}̃\bhŎw肳Ă
	 *          ܂ł{@link #gameMediator_}ƈقȂꍇB
	 */
	final public void setEditableNodeList(EditableNodeList editableNodeList) {
		ArgumentChecker.throwIfNull(editableNodeList);
		if (editableNodeList.equals(editableNodeList_)) {
			return;
		}
		if (editableNodeList_ != null) {
			throw new IllegalStateException("editableNodeList has already set."  //$NON-NLS-1$
					+ " last: " + editableNodeList_ + ", now: " +  editableNodeList); //$NON-NLS-1$ //$NON-NLS-2$
		}
		editableNodeList_ = editableNodeList;
	}


	/** 
	 * R}ĥ̖ݒ肵܂B
	 * [Ułꕶȉ̕w肵ĉB
	 * Fuω}ǉv
	 * 
	 * @throws org.unitarou.lang.NullArgumentException name<code>null</code>̏ꍇ
	 */
	public void setDisplayName(String name) {
	    ArgumentChecker.throwIfNull(name);
		displayName_ = name;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.lang.NameDisplayable#displayName()
	 */
	public String displayName() {
		return displayName_;
	}
	
    /**
	 * ݒڂĂ{@link org.unitarou.yukinoshita.model.NodeView}
	 * {@link org.unitarou.yukinoshita.model.NodeList}ɂ擪̃CfbNXŁA
	 * R}hsꂽ̍Wݒ肵܂B
	 * 
	 * @throws IllegalArgumentException executedNodeIndex̐l̏ꍇ
     */
    protected void setExecutedNodeIndex(int executedNodeIndex) {
        ArgumentChecker.throwIfNegative(executedNodeIndex);
        executedNodeIndex_ = executedNodeIndex;
    }

    /**
	 * R}hs̎_łNodeListłNodeView̃CfbNXԂ܂B
	 */
	public int getExecutedNodeIndex() {
	    return executedNodeIndex_;
	}

    /**
	 * ݒڂĂ{@link org.unitarou.yukinoshita.model.NodeView}
	 * {@link org.unitarou.yukinoshita.model.NodeList}ɂ擪̃CfbNXŁA
	 * R}hUNDOꂽ̍Wݒ肵܂B
	 * 
	 * @throws IllegalArgumentException undoneNodeIndex̐l̏ꍇ
     */
    protected void setUndoneNodeIndex(int undoneNodeIndex) {
        ArgumentChecker.throwIfNegative(undoneNodeIndex);
        undoneNodeIndex_ = undoneNodeIndex;
    }

    /**
	 * R}hundołNodeListłNodeView̃CfbNXԂ܂B
	 */
    public int getUndoneNodeIndex() {
        return undoneNodeIndex_;
    }
    
    /**
     * xݒsR}hłB<br>
     * KvȒlSetĂĐݒ肪ꍇtrueԂ܂B<br>
     * {@link #execute()}A{@link #undo()}ŏԔƂĎg܂B
     * ̃\bh͕Ă΂邱Ƃ܂B
     * Kvł΃TuNX͐ݒ肪sꂽǂێāA
     * xݒsȂ悤ɂĂB
     * @return KvȒlSetĂĐݒ肪^ĂꍇtrueB
     *           ̃NX̎͏trueԂ܂B
     */
    protected boolean setup() {
    	return true;
    }
    
    
    /**
     * {@link #setup()}ĂяoāA
     * xݒ肪łĂ邩`FbN܂B
     * TuNXł͎ۂ̃R}hsO
     * eNX̂̃\bhĂяoĂB
     * Ȃƒxݒ肪܂B
	 * @see org.unitarou.cmd.AbstractCommand#execute()
	 */
	@Override
	public void execute() {
		if (!setup()) {
			throw new IllegalStateException("Can't setup."); //$NON-NLS-1$
		}
		super.execute();
	}


	/**
     * {@link #setup()}ĂяoāA
     * xݒ肪łĂ邩`FbN܂B
     * TuNXł͎ۂ̃R}hsO
     * eNX̂̃\bhĂяoĂB
     * Ȃƒxݒ肪܂B
	 * @see org.unitarou.cmd.AbstractCommand#undo()
	 */
	@Override
	public void undo() {
		if (!setup()) {
			throw new IllegalStateException("Can't setup."); //$NON-NLS-1$
		}
		super.undo();
	}


	/**
     * R}hsꂽ̉é͈cViewXVȂ΂Ȃ͈͂Ԃ܂B 
     */
    abstract public EnumSet<ModelInfluence> getInfluence();
}
