/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class CommandFactory {

    /**
     * {@link UpdateProperty}쐬ĕԂ܂B<br>
     * newDatum̏ꍇnodeViewsgfType폜R}hɂȂ܂B<br>
     * ܂nodeView̒lnewDatumɍꍇnullԂ܂B
     *  
     * @param newDatum {@link Property#Property(SgfId, String)}ɒړn镶A󕶎̏ꍇ͍폜Ӗ܂B
     *                  <b>GXP[v͋֎~łB</b>
     * @param sgfId XVΏۂƂȂvpeB̌^
     * @param bindSameType trueɐݒ肷{@link SgfId#propertyType()}Node܂őkāA
     *                      (nodeViewł͂Ȃ)̃m[hXV܂B
     * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇB
     * @throws IllegalArgumentException sgfType {@link CardinalityType#SINGLE}ȊO̒lB
     */
    static public UpdateProperty createUpdateProperty(
    		String newDatum, SgfId sgfId, NodeView nodeView, boolean bindSameType) 
    {
    	ArgumentChecker.throwIfNull(newDatum, sgfId, nodeView);
    	if (!sgfId.cardinalityType().equals(CardinalityType.SINGLE)) {
    		throw new IllegalArgumentException("Bad carinality, property must be single: " + sgfId); //$NON-NLS-1$
    	}
    	
        Property property = nodeView.findProperty(sgfId);
        String lastDatum = Strings.EMPTY;
        if (property != null) {
            lastDatum = property.getString();
        }
        if (newDatum.equals(lastDatum)) {
            return null;
        }
        if (newDatum.equals(Strings.EMPTY)) { // 폜
            // GameInfo㗬NodeɍXV悤Ɏw
            property = new Property(sgfId, lastDatum);
            return new UpdateProperty(
            			new Property[]{property}, 
            			null, 
            			(bindSameType) ? sgfId.propertyType() : null);
        }
        // GameInfo㗬NodeɍXV悤Ɏw
        property = new Property(sgfId, newDatum);
        return new UpdateProperty(
        			new Property[0], 
        			property, 
        			(bindSameType) ? sgfId.propertyType() : null);
    }

    /**
	 * 
	 */
	protected CommandFactory() {
		super();
	}

}
