/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;

import org.unitarou.cmd.Command;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;

/**
 * {@link org.unitarou.yukinoshita.model.EditableNodeList}̎w肳ꂽ
 * ꏊ{@link org.unitarou.sgf.Node}ǉR}hłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class InsertNode extends Command4NodeList {
	/** um[h}v */
	static private final MessageResource LB_NAME 
		= new MessageResource(InsertNode.class, "lbName"); //$NON-NLS-1$

	private final Command sgfCommand_;
	private final GameTree targetTree_;
	private final EditableNodeList nodeList_;
	private final NodeEntity insertPoint_;
	private final Node newNode_;
	private NodeEntity newNodeView_;

	/**
	 * nodeIndex̒OnewNode}܂B
	 * nodeList̖ɑ}ꍇ{@link AddNode}p܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 * @throws IllegalArgumentException nodeIndexnodeList͈̔͂𒴂Ăꍇ
	 */
	public InsertNode(
	        EditableNodeList nodeList, 
	        Node newNode) 
	{
		super();
		ArgumentChecker.throwIfNull(nodeList, newNode);
		
		nodeList_ = nodeList;
		insertPoint_ = nodeList_.getPosition();
		newNode_  = newNode;
		targetTree_ = insertPoint_.getNodeTree().getGameTree();
		Node insertPointNode = insertPoint_.getNode();
		sgfCommand_ = new org.unitarou.sgf.cmd.InsertNode(targetTree_, insertPointNode, newNode_);
		
		setDisplayName(LB_NAME.get());
		setExecutedNodeIndex(nodeList_.getPositionIndex());
		setUndoneNodeIndex(nodeList_.getPositionIndex());
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		sgfCommand_.execute();
		newNodeView_ = nodeList_.insert(newNode_, targetTree_, insertPoint_);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		sgfCommand_.undo();
		nodeList_.remove(newNodeView_);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getCommandInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		return EnumSet.of(ModelInfluence.NODE_CURRENT);
	}
}
