/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;

import org.unitarou.cmd.Command;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.cmd.RemoveNode;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;

/**
 * ݒڂĂ{@link org.unitarou.yukinoshita.model.NodeEntity}폜܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class RemoveCurrentNode extends Command4NodeList {

    /** ũ݂m[h폜v*/
	static private final MessageResource LB_NAME 
			= new MessageResource(RemoveCurrentNode.class, "lbName"); //$NON-NLS-1$

	private boolean isSetuped_ = false;
	private Command sgfCommand_;
	
	/**
	 * 
	 */
	public RemoveCurrentNode() {
		super();
		sgfCommand_ = null;
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#setup()
	 */
	@Override
	protected boolean setup() {
		if (isSetuped_) {
			return true;
		}
		EditableNodeList nodeList = getEditableNodeList();
		if (nodeList == null) {
			return false;
		}
		
		setDisplayName(LB_NAME.get());
		NodeEntity nodeEntity = nodeList.getPosition();
		sgfCommand_ = new RemoveNode(nodeEntity.getNodeTree().getGameTree(), nodeEntity.getNode());

		final int positionIndex = nodeList.getPositionIndex();
		setExecutedNodeIndex(positionIndex - 1);
		setUndoneNodeIndex(positionIndex);
		isSetuped_ = true;
		return true;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.AbstractCommand#execute()
	 */
	@Override
	public void execute() {
		super.execute();

		sgfCommand_.execute();
		
		// 폜ONodeEntity烂fXgč\z
		EditableNodeList nodeList = getEditableNodeList();
		nodeList.setPositionIndex(getExecutedNodeIndex());
		NodeEntity entity = nodeList.getPosition();
		while (!entity.equals(nodeList.removeLast())) {
			// Ȃ
		} 
		nodeList.addLast(entity);
		GameTree gameTree = entity.getNodeTree().getGameTree();
		boolean found = false;
		for (Node node : gameTree.getSequence()) {
			if (node == entity.getNode()) {
				found = true;
				continue;
			}
			if (!found) {
				continue;
			}
			
			// 폜ONode̎XV
			getEditableNodeList().addLast(node, gameTree);
		}
		if (gameTree.getChildrenSize() != 0) {
			getEditableNodeList().addLast(gameTree.getChild(0));
		}
	}



	/* (non-Javadoc)
	 * @see org.unitarou.cmd.AbstractCommand#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		sgfCommand_.undo();
		
		// 폜NodeEntity烂fXgč\z
		EditableNodeList nodeList = getEditableNodeList();
		nodeList.setPositionIndex(getExecutedNodeIndex());
		NodeEntity entity = nodeList.getPosition();
		while (!entity.equals(nodeList.removeLast())) {
			// Ȃ
		} 
		GameTree gameTree = entity.getNodeTree().getGameTree();
		boolean found = false;
		for (Node node : gameTree.getSequence()) {
			if (node == entity.getNode()) {
				found = true;
			}
			if (!found) {
				continue;
			}
			
			// 폜NodeXV
			getEditableNodeList().addLast(node, gameTree);
		}
		if (gameTree.getChildrenSize() != 0) {
			getEditableNodeList().addLast(gameTree.getChild(0));
		}
		//TODO Kv`FbN(GameMediatorŃ`FbNĂ͂c)
		nodeList.setPositionIndex(getUndoneNodeIndex());
	}



	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		return EnumSet.of(ModelInfluence.NODE_DOWNWARD, ModelInfluence.NODE_CURRENT);
	}
}
