/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;

import org.unitarou.cmd.Command;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Sequence;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeTree;


/**
 * {@link org.unitarou.sgf.cmd.RemoveLastNode}sA
 * {@link org.unitarou.yukinoshita.model.EditableNodeList}̖폜܂B
 * ŕω}̍ŏ̃m[h폜ꍇ́ACpX̃c[\܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class RemoveLastNode extends Command4NodeList {
	
    /** uŊ̃m[h폜v*/
	static private final MessageResource LB_NAME 
			= new MessageResource(RemoveLastNode.class, "lbName"); //$NON-NLS-1$

	private Command sgfCommand_;
	private NodeEntity removedEntity_;
	private NodeEntity appendPoint_;
	private int childStyleVariationIndex_;
	private boolean isChildlenMode_;
	private boolean isSetuped_;

	/**
	 * @param target
	 * @param parent
	 */
	public RemoveLastNode() {
		super();
		childStyleVariationIndex_ = -1;
		isSetuped_ = false;
	}

	/**
	 * {@link Command4NodeList#getEditableNodeList()}
	 * p[^\܂B
	 * \ɐꍇA܂͂łɍ\ĂꍇtrueԂ܂B
	 * @return
	 */
	@Override
	protected boolean setup() {
		if (isSetuped_) {
			return true;
		}
		EditableNodeList nodeList = getEditableNodeList();
		if (nodeList == null) {
			return false;
		}
		NodeTree nodeTree = nodeList.getLast().getNodeTree();
		removedEntity_ = null;
		setDisplayName(LB_NAME.get());
		setExecutedNodeIndex(nodeList.size() - 2);
		setUndoneNodeIndex(nodeList.size() - 1);
		isChildlenMode_ = nodeTree.isChildrenStyle();
		if (isChildlenMode_) {
			// eq^̏ꍇAXVÕCfbNXێ
			childStyleVariationIndex_ 
					= getEditableNodeList().getLast().getPrevious().getSelectedVariationIndex();
		}
		isSetuped_ = true;
		return true;
	}


	/**
	 * {@link org.unitarou.sgf.cmd.RemoveLastNode}sA
	 * {@link org.unitarou.yukinoshita.model.EditableNodeList}̖폜܂B
	 * ŕω}̍ŏ̃m[h폜ꍇ́ACpX̃c[\܂B
	 * 
	 * @see org.unitarou.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		
		EditableNodeList nodeList = getEditableNodeList();
		NodeTree nt = nodeList.getLast().getNodeTree();
		sgfCommand_ = new org.unitarou.sgf.cmd.RemoveLastNode(nt.getGameTree());

		// 폜O̒iKŃV[PXNodePŕ򂪂Q̏ꍇ́A
		// fŃc[č\̂ŁA
		// OeditableNodeList_ΉKvB
		// ̓Iɂ͎c̃m[hŌ܂łSăXgɒǉB
		// ܂NodePŕ򂪂Qȏ̏ꍇ́A{𖖔ɒǉB
		// ȊȌꍇ͒Pɍ폜
		appendPoint_ = getEditableNodeList().getLast().getPrevious();
		removedEntity_ = getEditableNodeList().removeLast();
		NodeTree nodeTree = removedEntity_.getNodeTree();
		
		
		if ((1 == nodeTree.getGameTree().getSequence().size()) 
				&& (nodeTree.getParentGameTree() != null)
		    	&& (2 == nodeTree.getParentGameTree().getChildrenSize())) 
		{
			sgfCommand_.execute();
			if (getEditableNodeList().size() != 0) {
			    NodeEntity last = getEditableNodeList().getLast(); 
				if (isChildlenMode_) {
					// eq^̏ꍇAω}폜ꂽꍇ̓CfbNXXVB
					last.updateVariationIndex();
				}
			    GameTree gameTree = last.getNodeTree().getGameTree();
			    Node node = last.getNode();
			    Sequence.Iterator ip;
			    for (ip = gameTree.getSequence().iterator(); ip.hasNext(); ) {
			        if (node == ip.next()) {
			            break;
			        }
			    }
			    while(ip.hasNext()) {
			    	getEditableNodeList().addLast(ip.next(), gameTree);
			    }
			    if (gameTree.getChildrenSize() != 0) {
				    getEditableNodeList().addLast(gameTree.getChild(0));
			    }
			}
			
		} else if (1 == removedEntity_.getNodeTree().getGameTree().getSequence().size()) {
			sgfCommand_.execute();
			if (getEditableNodeList().size() != 0) {
			    NodeEntity last = getEditableNodeList().getLast();
			    GameTree[] gameTrees = last.getNodeTree().getGameTree().getChildren();
			    assert gameTrees.length != 0 : "Lost child tree."; //$NON-NLS-1$
			    getEditableNodeList().addLast(gameTrees[0]);
			}
		    
		} else {
			sgfCommand_.execute();
		}
	}
	

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		
		sgfCommand_.undo();
		if (isRebuildMode()) {
			// c[̍č\ꍇ́AeditableNodeListc[̍폜|Cg܂
			// 폜āǍNodeeEnitity𑫂KvB
			NodeEntity removed = getEditableNodeList().removeLast();
			while (!removed.equals(appendPoint_)) {
				removed = getEditableNodeList().removeLast();
			}
			getEditableNodeList().addLast(appendPoint_);
			getEditableNodeList().addLast(removedEntity_);
	    
			if (isChildlenMode_) {
				// eq^̏ꍇ͒ǉω}̃CfbNXXVB
				removedEntity_.getPrevious().setSelectedVariationIndex(childStyleVariationIndex_);
			}
		} else {
			// 򂪌疳ꍇ╪򂪂Qȏ゠ꍇ
			// ʂɖ߂(ŌNodeEnitity𑫂)΂悢B
			getEditableNodeList().addLast(removedEntity_);
		}
	}
	
	private boolean isRebuildMode() {
		NodeTree nodeTree = removedEntity_.getNodeTree();
		if (!nodeTree.isLastNode()) {
			return false;
			
		}
		if (isChildlenMode_) {
			return removedEntity_.getPrevious().getNodeTree().getVariationSize() != 0;
		}
		return nodeTree.getVariationSize() != 0;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getCommandInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		EnumSet<ModelInfluence> ret = EnumSet.of(ModelInfluence.NODE_CURRENT);
		if (isChildlenMode_) {
			ret.add(ModelInfluence.NODE_PEVIOUS);
		}
		return ret;
	}
}
