/*
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;

import org.unitarou.cmd.Command;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.cmd.RemoveGameTree;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeTree;

/**
 * index̑GameTreeSč폜܂B
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class RemoveVariation extends Command4NodeList {
	/** uω}폜v */
	static private final MessageResource LB_NAME 
			= new MessageResource(RemoveVariation.class, "lbName"); //$NON-NLS-1$

	private final int targetIndex_;
	private boolean isSetuped_;
	private Command sgfCommand_;
	private GameTree target_;
	private NodeEntity undoStart_;

	/**
	 * index̑GameTreeSč폜܂B
	 * @param target
	 */
	public RemoveVariation(int targetIndex) {
		super();
		targetIndex_ = targetIndex;
		isSetuped_ = false;
		sgfCommand_ = null;
		target_ = null;
		undoStart_ = null;
		setDisplayName(LB_NAME.get());
		
	}

	/**
	 * {@link Command4NodeList#getEditableNodeList()}
	 * p[^\܂B
	 * \ɐꍇA܂͂łɍ\ĂꍇtrueԂ܂B
	 * @return
	 */
	@Override
	protected boolean setup() {
		if (isSetuped_) {
			return true;
		}
		EditableNodeList nodeList_ = getEditableNodeList();
		if (nodeList_ == null) {
			return false;
		}
		if (targetIndex_ < 0 || nodeList_.size() <= targetIndex_ ) {
			throw new IndexOutOfBoundsException("index = " + targetIndex_); //$NON-NLS-1$
		}
		undoStart_ = null;

		setExecutedNodeIndex(nodeList_.getPositionIndex());
		setUndoneNodeIndex(nodeList_.getPositionIndex());
		isSetuped_ = true;
		return true;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		NodeEntity target = getEditableNodeList().get(targetIndex_); 
		NodeTree nodeTree = target.getNodeTree();
		sgfCommand_ = new RemoveGameTree(
		        nodeTree.getParentGameTree(), nodeTree.getGameTree());
		target_ = nodeTree.getGameTree();

		sgfCommand_.execute();
		
		NodeEntity last = getEditableNodeList().removeLast();
		while(last.getNodeTree().getGameTree().equals(target_)) {
			last = getEditableNodeList().removeLast();
		}
		
		NodeEntity start = getEditableNodeList().removeLast();
		undoStart_ = start;
		getEditableNodeList().addLast(start);
		
		updateMoveList(start);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		sgfCommand_.undo();
		
		NodeEntity last = getEditableNodeList().removeLast();
		while(last.equals(undoStart_)) {
			last = getEditableNodeList().removeLast();
		}

		updateMoveList(undoStart_);
	}
	
	private void updateMoveList(NodeEntity start) {
	    GameTree startGameTree = start.getNodeTree().getGameTree();
		Sequence.Iterator ip = startGameTree.getSequence().iterator();
		while(ip.hasNext()) {
			if (ip.next().equals(start.getNode()))  {
				while(ip.hasNext()) {
					getEditableNodeList().addLast(ip.next(), startGameTree);
				}
			}
		}
		GameTree[] child = startGameTree.getChildren();
		if (child.length != 0) {
			getEditableNodeList().addLast(child[0]);
		}
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getCommandInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		return EnumSet.of(ModelInfluence.NODE_CURRENT);
	}
}
