/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import java.util.LinkedList;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.cmd.Command;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;

/**
 * ω}IR}hłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class SelectVariation extends Command4NodeList {
	/** uω}Iv */
	static private final MessageResource LB_NAME 
			= new MessageResource(SelectVariation.class, "lbName"); //$NON-NLS-1$

	private final int newVariationIndex_;
	private NodeEntity targetNode_;
	private int targetPosition_;
	private int lastIndex_;
	
	/** ^[{@link NodeEntity}]łB */
	private LinkedList<NodeEntity> removedChain_;
	
	/**
	 * ۂɓsR}hCX^XłB
	 * eq^ƌZ^ŃCX^XقȂ܂B
	 */ 
	private Command commandImpl_;

	/**
	 * @throws org.unitarou.lang.NullArgumentException nodeList, targetNodenull̏ꍇ
	 * @throws IllegalArgumentException newIndex̐̏ꍇB
	 */
	public SelectVariation(int newIndex) {
		super();
		if (newIndex < 0) {
		    throw new IllegalArgumentException("newIndex must not be negative number: newIndex = " + newIndex); //$NON-NLS-1$
		}
		newVariationIndex_ = newIndex;
		targetPosition_ = -1;
		commandImpl_ = null;
		removedChain_ = null;
	}

	/**
	 * {@link Command4NodeList#getEditableNodeList()}
	 * p[^\܂B
	 * \ɐꍇA܂͂łɍ\ĂꍇtrueԂ܂B
	 * @return
	 */
	@Override
	protected boolean setup() {
		if (0 <= targetPosition_) {
			return true;
		}
		EditableNodeList nodeList = getEditableNodeList();
		if (nodeList == null) {
			return false;
		}
		targetPosition_ = nodeList.getPositionIndex();
		
		setDisplayName(LB_NAME.get());
		setExecutedNodeIndex(nodeList.getPositionIndex());
		setUndoneNodeIndex(nodeList.getPositionIndex());
		return true;
	}

	/**
	 * ChildrenStyleSiblingStyleœ삪قȂ܂A
	 * ǂRXgN^Ŏw肵nodeEntity̒O܂ł폜āA
	 * newIndexŎw肵ǉ܂B
	 * 
	 * @see org.unitarou.cmd.Command#execute()
	 */
	@Override
	public void execute() {
	    super.execute();

	    targetNode_ = getEditableNodeList().get(targetPosition_);
		if ((newVariationIndex_ < 0) || (targetNode_.getNodeTree().getVariationSize() <= newVariationIndex_)) {
			throw new IndexOutOfBoundsException("A new index is " + newVariationIndex_  //$NON-NLS-1$
											   + " but target.size is " + targetNode_.getNodeTree().getVariationSize() + ".");  //$NON-NLS-1$//$NON-NLS-2$
		}
		lastIndex_ = targetNode_.getSelectedVariationIndex();

		if (targetNode_.getNodeTree().isChildrenStyle()) {
		    commandImpl_ = new SelectVariationAsChildren(); 
		} else {
		    commandImpl_ = new SelectVariationAsSibling(); 
		}

		if (newVariationIndex_ == lastIndex_) {
			return;
		}
		commandImpl_.execute();
	}
	

	/**
	 * eq^ƌZ^ŏقȂ邪A
	 * ǂȑOɕێɖ߂sB
	 * 
	 * @see org.unitarou.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		if (newVariationIndex_ == lastIndex_) {
			return;
		}
		commandImpl_.undo();
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.model.cmd.Command4NodeList#getCommandInfluence()
	 */
	@Override
	public EnumSet<ModelInfluence> getInfluence() {
		return EnumSet.of(ModelInfluence.NODE_CURRENT);
	}

	/**
	 * eq^̊ɑ΂ĕϐ̑IundoNXłB
	 */
	private class SelectVariationAsChildren extends AbstractCommand {

        public SelectVariationAsChildren() {
            super();
        }

    	/**
    	 * eq^̏ꍇ́AŌ̃m[h̕ω}index{@link #newVariationIndex_}ɐݒ肵A
    	 * ̌Ɏۂ{@link #newVariationIndex_}Ŏw肵ǉB
         * @see org.unitarou.cmd.Command#execute()
    	 */
        @Override
		public void execute() {
            assert targetNode_.getNodeTree().isChildrenStyle() : "Sibling style must not user this class."; //$NON-NLS-1$
    		super.execute();

    		removedChain_ = new LinkedList<NodeEntity>();
    		NodeEntity last = getEditableNodeList().removeLast();
    		while(!last.equals(targetNode_)) {
    			removedChain_.addFirst(last);
    			last = getEditableNodeList().removeLast();
    		}
    		getEditableNodeList().addLast(last);
			targetNode_.setSelectedVariationIndex(newVariationIndex_);
			GameTree target = targetNode_.getNodeTree().getGameTree(); 
			getEditableNodeList().addLast(target.getChild(newVariationIndex_));
        }
        
        
        /**
         * eq^̏ꍇ́A{@link SelectVariation#targetNode_}̂܂܎cĂ̂ŁA
         * ̕ω}؂ւāA{@link SelectVariation#targetNode_}܂ł폜A
         * ȑO{@link SelectVariation#removedChain_}𕜋AB
         * 
         * @see org.unitarou.cmd.Command#undo()
         */
        @Override
		public void undo() {
            assert targetNode_.getNodeTree().isChildrenStyle() : "Sibling style must not user this class."; //$NON-NLS-1$
            super.undo();
    		
			targetNode_.setSelectedVariationIndex(lastIndex_);
    		
    		NodeEntity last = getEditableNodeList().removeLast();
    		while(!last.equals(targetNode_)) {
    			last = getEditableNodeList().removeLast();
    		}
    		getEditableNodeList().addLast(last);
    		getEditableNodeList().addLast(
    		        removedChain_.toArray(
    		                	new NodeEntity[removedChain_.size()]));
    		removedChain_ = null;
        }
	}
	
	/**
	 * Z^̊ɑ΂ĕϐ̑IundoNXłB
	 */
	private class SelectVariationAsSibling extends AbstractCommand {
	    /** 
	     * R}hsɂĕύXȂŌ̃m[hێ܂B
	     * [gm[hŐ؂ւꍇnullێ܂B
	     */
	    private NodeEntity unchangedLastNode_;
	    
	    public SelectVariationAsSibling() {
            super();
        }
	    
		/**
		 * Z^̏ꍇ͍Ō̃m[h̐em[h̕ω}index{@link #newVariationIndex_}ɐݒ肵A
		 * ̌Ɏۂ{@link #newVariationIndex_}Ŏw肵ǉB
		 * ܂A[gm[hł̐؂ւĕω}indexV̍ŏ̃m[hŎw肷B
         * @see org.unitarou.cmd.Command#execute()
		 */
        @Override
		public void execute() {
            assert !targetNode_.getNodeTree().isChildrenStyle() : "Children style must not user this class."; //$NON-NLS-1$
    		super.execute();
    		
    		removedChain_ = new LinkedList<NodeEntity>();
    		NodeEntity last = getEditableNodeList().removeLast();
    		while(!last.equals(targetNode_)) {
    			removedChain_.addFirst(last);
    			if (getEditableNodeList().size() == 0) {
    			    break;
    			}
    			last = getEditableNodeList().removeLast();
    		}

			int lastIndex = getEditableNodeList().size();
			unchangedLastNode_ = (lastIndex != 0) ? getEditableNodeList().getLast() : null;

			GameTree target = targetNode_.getNodeTree().getParentGameTree();
			getEditableNodeList().addLast(target.getChild(newVariationIndex_));
			// ǉύXŏ̃m[hɕԍƍXVwoB
			getEditableNodeList().get(lastIndex).setSelectedVariationIndex(newVariationIndex_);
        }

        /**
         * Z^̏ꍇ
         * {@link #targetNode_}ŕω}̂hc߂
         * {@link #unchangedLastNode_}̒O܂ł폜B
         * targetNode_ǉremovedChain𕜋AB
         * @see org.unitarou.cmd.Command#undo()
         */
        @Override
		public void undo() {
            assert !targetNode_.getNodeTree().isChildrenStyle() : "Children style must not user this class."; //$NON-NLS-1$
            super.undo();

    		NodeEntity last = getEditableNodeList().removeLast();
    		while(!last.equals(unchangedLastNode_)) {
    		    if (getEditableNodeList().size() == 0) {
    		        break;
    		    }
    			last = getEditableNodeList().removeLast();
    		}
    		if (unchangedLastNode_ != null) {
    			getEditableNodeList().addLast(unchangedLastNode_);
    		}
    		targetNode_.setSelectedVariationIndex(lastIndex_);
    		
    		getEditableNodeList().addLast(targetNode_);
    		getEditableNodeList().addLast(
    		        removedChain_.toArray(
    		                	new NodeEntity[removedChain_.size()]));
    		removedChain_ = null;
    		unchangedLastNode_ = null;
        }
	}

}
